/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollPaneBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ScrollPaneSkin
extends SkinBase<ScrollPane, ScrollPaneBehavior>
implements TraverseListener {
    private static final double DEFAULT_PREF_SIZE = 100.0;
    private static final double DEFAULT_MIN_SIZE = 36.0;
    private static final double DEFAULT_SB_BREADTH = 12.0;
    private static final double PAN_THRESHOLD = 0.5;
    private Node scrollNode;
    private double nodeWidth;
    private double nodeHeight;
    private double posX;
    private double posY;
    private boolean hsbvis;
    private boolean vsbvis;
    private double hsbHeight;
    private double vsbWidth;
    private StackPane viewRect;
    private double contentWidth;
    private double contentHeight;
    private StackPane corner;
    protected ScrollBar hsb;
    protected ScrollBar vsb;
    double pressX;
    double pressY;
    double ohvalue;
    double ovvalue;
    private Cursor saveCursor = null;
    private boolean dragDetected = false;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    Rectangle clipRect;
    private final InvalidationListener nodeListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            if (ScrollPaneSkin.this.nodeWidth != -1.0 && ScrollPaneSkin.this.nodeHeight != -1.0) {
                Bounds bounds = ScrollPaneSkin.this.scrollNode.getLayoutBounds();
                double d = bounds.getWidth();
                double d2 = bounds.getHeight();
                if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible() || d != 0.0 && ScrollPaneSkin.this.nodeWidth != d || d2 != 0.0 && ScrollPaneSkin.this.nodeHeight != d2) {
                    ScrollPaneSkin.this.requestLayout();
                } else {
                    ScrollPaneSkin.this.updateVerticalSB();
                    ScrollPaneSkin.this.updateHorizontalSB();
                }
            }
        }
    };
    private final ChangeListener<Bounds> boundsChangeListener = new ChangeListener<Bounds>(){

        @Override
        public void changed(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = bounds.getHeight();
            if (d5 != (d4 = bounds2.getHeight())) {
                d3 = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.getInsets().getTop() - ScrollPaneSkin.this.posY / (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin()) * (d5 - ScrollPaneSkin.this.contentHeight));
                d = d3 / (d2 = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.getInsets().getTop() - ScrollPaneSkin.this.posY / (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin()) * (d4 - ScrollPaneSkin.this.contentHeight))) * ScrollPaneSkin.this.vsb.getValue();
                if (d < 0.0) {
                    ScrollPaneSkin.this.vsb.setValue(0.0);
                } else if (d < 1.0) {
                    ScrollPaneSkin.this.vsb.setValue(d);
                } else if (d > 1.0) {
                    ScrollPaneSkin.this.vsb.setValue(1.0);
                }
            }
            if ((d3 = bounds.getWidth()) != (d2 = bounds2.getWidth())) {
                double d6;
                d = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.getInsets().getLeft() - ScrollPaneSkin.this.posX / (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin()) * (d3 - ScrollPaneSkin.this.contentWidth));
                double d7 = d / (d6 = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.getInsets().getLeft() - ScrollPaneSkin.this.posX / (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin()) * (d2 - ScrollPaneSkin.this.contentWidth))) * ScrollPaneSkin.this.hsb.getValue();
                if (d7 < 0.0) {
                    ScrollPaneSkin.this.hsb.setValue(0.0);
                } else if (d7 < 1.0) {
                    ScrollPaneSkin.this.hsb.setValue(d7);
                } else if (d7 > 1.0) {
                    ScrollPaneSkin.this.hsb.setValue(1.0);
                }
            }
        }
    };
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    Timeline contentsToViewTimeline;
    KeyFrame contentsToViewKF1;
    KeyFrame contentsToViewKF2;
    KeyFrame contentsToViewKF3;
    private boolean tempVisibility;
    private DoubleProperty contentPosX;
    private DoubleProperty contentPosY;

    public ScrollPaneSkin(ScrollPane scrollPane) {
        super(scrollPane, new ScrollPaneBehavior(scrollPane));
        this.initialize();
        this.registerChangeListener(scrollPane.contentProperty(), "NODE");
        this.registerChangeListener(scrollPane.fitToWidthProperty(), "FIT_TO_WIDTH");
        this.registerChangeListener(scrollPane.fitToHeightProperty(), "FIT_TO_HEIGHT");
        this.registerChangeListener(scrollPane.hbarPolicyProperty(), "HBAR_POLICY");
        this.registerChangeListener(scrollPane.vbarPolicyProperty(), "VBAR_POLICY");
        this.registerChangeListener(scrollPane.hvalueProperty(), "HVALUE");
        this.registerChangeListener(scrollPane.vvalueProperty(), "VVALUE");
        this.registerChangeListener(scrollPane.prefViewportWidthProperty(), "PREF_VIEWPORT_WIDTH");
        this.registerChangeListener(scrollPane.prefViewportHeightProperty(), "PREF_VIEWPORT_HEIGHT");
    }

    private void initialize() {
        this.setManaged(false);
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        this.scrollNode = scrollPane.getContent();
        if (this.scrollNode != null) {
            this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
            this.scrollNode.layoutBoundsProperty().addListener(this.boundsChangeListener);
        }
        this.viewRect = new StackPane(){

            @Override
            public void requestLayout() {
                ScrollPaneSkin.this.nodeWidth = -1.0;
                ScrollPaneSkin.this.nodeHeight = -1.0;
                super.requestLayout();
            }

            @Override
            protected void layoutChildren() {
                if (ScrollPaneSkin.this.nodeWidth == -1.0 || ScrollPaneSkin.this.nodeHeight == -1.0) {
                    ScrollPaneSkin.this.computeScrollNodeSize(this.getWidth(), this.getHeight());
                }
                if (ScrollPaneSkin.this.scrollNode != null && ScrollPaneSkin.this.scrollNode.isResizable()) {
                    ScrollPaneSkin.this.scrollNode.resize(this.snapSize(ScrollPaneSkin.this.nodeWidth), this.snapSize(ScrollPaneSkin.this.nodeHeight));
                    if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible()) {
                        ScrollPaneSkin.this.requestLayout();
                    }
                }
                if (ScrollPaneSkin.this.scrollNode != null) {
                    ScrollPaneSkin.this.scrollNode.relocate(0.0, 0.0);
                }
            }
        };
        this.viewRect.setManaged(false);
        this.clipRect = new Rectangle();
        this.viewRect.setClip(this.clipRect);
        this.hsb = new ScrollBar();
        this.vsb = new ScrollBar();
        this.vsb.setOrientation(Orientation.VERTICAL);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.viewRect.getChildren().clear();
        if (this.scrollNode != null) {
            this.viewRect.getChildren().add(this.scrollNode);
        }
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.viewRect, this.vsb, this.hsb, this.corner});
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (!PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.posY = Utils.clamp(((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmin(), ScrollPaneSkin.this.vsb.getValue(), ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmax());
                } else {
                    ScrollPaneSkin.this.posY = ScrollPaneSkin.this.vsb.getValue();
                }
                ScrollPaneSkin.this.updatePosY();
            }
        };
        this.vsb.valueProperty().addListener(invalidationListener);
        InvalidationListener invalidationListener2 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (!PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.posX = Utils.clamp(((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmin(), ScrollPaneSkin.this.hsb.getValue(), ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmax());
                } else {
                    ScrollPaneSkin.this.posX = ScrollPaneSkin.this.hsb.getValue();
                }
                ScrollPaneSkin.this.updatePosX();
            }
        };
        this.hsb.valueProperty().addListener(invalidationListener2);
        this.viewRect.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.startSBReleasedAnimation();
                }
                ScrollPaneSkin.this.mouseDown = true;
                ScrollPaneSkin.this.pressX = mouseEvent.getX() + ScrollPaneSkin.this.viewRect.getLayoutX();
                ScrollPaneSkin.this.pressY = mouseEvent.getY() + ScrollPaneSkin.this.viewRect.getLayoutY();
                ScrollPaneSkin.this.ohvalue = ScrollPaneSkin.this.hsb.getValue();
                ScrollPaneSkin.this.ovvalue = ScrollPaneSkin.this.vsb.getValue();
            }
        });
        this.viewRect.setOnDragDetected((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.startSBReleasedAnimation();
                }
                if (((ScrollPane)ScrollPaneSkin.this.getSkinnable()).isPannable()) {
                    ScrollPaneSkin.this.dragDetected = true;
                    if (ScrollPaneSkin.this.saveCursor == null) {
                        ScrollPaneSkin.this.saveCursor = ScrollPaneSkin.this.getCursor();
                        if (ScrollPaneSkin.this.saveCursor == null) {
                            ScrollPaneSkin.this.saveCursor = Cursor.DEFAULT;
                        }
                        ScrollPaneSkin.this.setCursor(Cursor.MOVE);
                        ScrollPaneSkin.this.requestLayout();
                    }
                }
            }
        });
        this.viewRect.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.startSBReleasedAnimation();
                }
                ScrollPaneSkin.this.mouseDown = false;
                if (ScrollPaneSkin.this.dragDetected) {
                    if (ScrollPaneSkin.this.saveCursor != null) {
                        ScrollPaneSkin.this.setCursor(ScrollPaneSkin.this.saveCursor);
                        ScrollPaneSkin.this.saveCursor = null;
                        ScrollPaneSkin.this.requestLayout();
                    }
                    ScrollPaneSkin.this.dragDetected = false;
                }
                if ((ScrollPaneSkin.this.posY > ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmax() || ScrollPaneSkin.this.posY < ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmin() || ScrollPaneSkin.this.posX > ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmax() || ScrollPaneSkin.this.posX < ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmin()) && !ScrollPaneSkin.this.touchDetected) {
                    ScrollPaneSkin.this.startContentsToViewport();
                }
            }
        });
        this.viewRect.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.startSBReleasedAnimation();
                }
                if (((ScrollPane)ScrollPaneSkin.this.getSkinnable()).isPannable() || PlatformUtil.isEmbedded()) {
                    double d;
                    double d2 = ScrollPaneSkin.this.pressX - (mouseEvent.getX() + ScrollPaneSkin.this.viewRect.getLayoutX());
                    double d3 = ScrollPaneSkin.this.pressY - (mouseEvent.getY() + ScrollPaneSkin.this.viewRect.getLayoutY());
                    if (ScrollPaneSkin.this.hsb.getVisibleAmount() > 0.0 && ScrollPaneSkin.this.hsb.getVisibleAmount() < ScrollPaneSkin.this.hsb.getMax() && Math.abs(d2) > 0.5) {
                        d = ScrollPaneSkin.this.ohvalue + d2 / (ScrollPaneSkin.this.nodeWidth - ScrollPaneSkin.this.viewRect.getWidth()) * (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin());
                        if (!PlatformUtil.isEmbedded()) {
                            if (d > ScrollPaneSkin.this.hsb.getMax()) {
                                d = ScrollPaneSkin.this.hsb.getMax();
                            } else if (d < ScrollPaneSkin.this.hsb.getMin()) {
                                d = ScrollPaneSkin.this.hsb.getMin();
                            }
                            ScrollPaneSkin.this.hsb.setValue(d);
                        } else {
                            ScrollPaneSkin.this.hsb.setValue(d);
                        }
                    }
                    if (ScrollPaneSkin.this.vsb.getVisibleAmount() > 0.0 && ScrollPaneSkin.this.vsb.getVisibleAmount() < ScrollPaneSkin.this.vsb.getMax() && Math.abs(d3) > 0.5) {
                        d = ScrollPaneSkin.this.ovvalue + d3 / (ScrollPaneSkin.this.nodeHeight - ScrollPaneSkin.this.viewRect.getHeight()) * (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin());
                        if (!PlatformUtil.isEmbedded()) {
                            if (d > ScrollPaneSkin.this.vsb.getMax()) {
                                d = ScrollPaneSkin.this.vsb.getMax();
                            } else if (d < ScrollPaneSkin.this.vsb.getMin()) {
                                d = ScrollPaneSkin.this.vsb.getMin();
                            }
                            ScrollPaneSkin.this.vsb.setValue(d);
                        } else {
                            ScrollPaneSkin.this.vsb.setValue(d);
                        }
                    }
                }
                mouseEvent.consume();
            }
        });
        final EventDispatcher eventDispatcher = new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                return event;
            }
        };
        final EventDispatcher eventDispatcher2 = this.hsb.getEventDispatcher();
        this.hsb.setEventDispatcher(new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
                    return eventDispatchChain.dispatchEvent(event);
                }
                return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
            }
        });
        final EventDispatcher eventDispatcher3 = this.vsb.getEventDispatcher();
        this.vsb.setEventDispatcher(new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher3);
                    return eventDispatchChain.dispatchEvent(event);
                }
                return eventDispatcher3.dispatchEvent(event, eventDispatchChain);
            }
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                double d;
                double d2;
                double d3;
                if (PlatformUtil.isEmbedded()) {
                    ScrollPaneSkin.this.startSBReleasedAnimation();
                }
                if (ScrollPaneSkin.this.vsb.getVisibleAmount() < ScrollPaneSkin.this.vsb.getMax()) {
                    d3 = ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmax() - ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getVmin();
                    d2 = ScrollPaneSkin.this.nodeHeight > 0.0 ? d3 / ScrollPaneSkin.this.nodeHeight : 0.0;
                    d = ScrollPaneSkin.this.vsb.getValue() + -scrollEvent.getDeltaY() * d2;
                    if (!PlatformUtil.isEmbedded()) {
                        if (scrollEvent.getDeltaY() > 0.0 && ScrollPaneSkin.this.vsb.getValue() > ScrollPaneSkin.this.vsb.getMin() || scrollEvent.getDeltaY() < 0.0 && ScrollPaneSkin.this.vsb.getValue() < ScrollPaneSkin.this.vsb.getMax()) {
                            ScrollPaneSkin.this.vsb.setValue(d);
                            scrollEvent.consume();
                        }
                    } else if (!scrollEvent.isInertia() || scrollEvent.isInertia() && (ScrollPaneSkin.this.contentsToViewTimeline == null || ScrollPaneSkin.this.contentsToViewTimeline.getStatus() == Animation.Status.STOPPED)) {
                        ScrollPaneSkin.this.vsb.setValue(d);
                        if ((d > ScrollPaneSkin.this.vsb.getMax() || d < ScrollPaneSkin.this.vsb.getMin()) && !ScrollPaneSkin.this.mouseDown && !ScrollPaneSkin.this.touchDetected) {
                            ScrollPaneSkin.this.startContentsToViewport();
                        }
                        scrollEvent.consume();
                    }
                }
                if (ScrollPaneSkin.this.hsb.getVisibleAmount() < ScrollPaneSkin.this.hsb.getMax()) {
                    d3 = ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmax() - ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).getHmin();
                    d2 = ScrollPaneSkin.this.nodeWidth > 0.0 ? d3 / ScrollPaneSkin.this.nodeWidth : 0.0;
                    d = ScrollPaneSkin.this.hsb.getValue() + -scrollEvent.getDeltaX() * d2;
                    if (!PlatformUtil.isEmbedded()) {
                        if (scrollEvent.getDeltaX() > 0.0 && ScrollPaneSkin.this.hsb.getValue() > ScrollPaneSkin.this.hsb.getMin() || scrollEvent.getDeltaX() < 0.0 && ScrollPaneSkin.this.hsb.getValue() < ScrollPaneSkin.this.hsb.getMax()) {
                            ScrollPaneSkin.this.hsb.setValue(d);
                            scrollEvent.consume();
                        }
                    } else if (!scrollEvent.isInertia() || scrollEvent.isInertia() && (ScrollPaneSkin.this.contentsToViewTimeline == null || ScrollPaneSkin.this.contentsToViewTimeline.getStatus() == Animation.Status.STOPPED)) {
                        ScrollPaneSkin.this.hsb.setValue(d);
                        if ((d > ScrollPaneSkin.this.hsb.getMax() || d < ScrollPaneSkin.this.hsb.getMin()) && !ScrollPaneSkin.this.mouseDown && !ScrollPaneSkin.this.touchDetected) {
                            ScrollPaneSkin.this.startContentsToViewport();
                        }
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.setOnTouchPressed((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                ScrollPaneSkin.this.touchDetected = true;
                ScrollPaneSkin.this.startSBReleasedAnimation();
                touchEvent.consume();
            }
        });
        this.setOnTouchReleased((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                ScrollPaneSkin.this.touchDetected = false;
                ScrollPaneSkin.this.startSBReleasedAnimation();
                touchEvent.consume();
            }
        });
        TraversalEngine traversalEngine = new TraversalEngine(this, false);
        traversalEngine.addTraverseListener(this);
        this.setImpl_traversalEngine(traversalEngine);
        this.consumeMouseEvents(false);
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "NODE") {
            if (this.scrollNode != ((ScrollPane)this.getSkinnable()).getContent()) {
                if (this.scrollNode != null) {
                    this.scrollNode.layoutBoundsProperty().removeListener(this.nodeListener);
                    this.scrollNode.layoutBoundsProperty().removeListener(this.boundsChangeListener);
                    this.viewRect.getChildren().remove(this.scrollNode);
                }
                this.scrollNode = ((ScrollPane)this.getSkinnable()).getContent();
                if (this.scrollNode != null) {
                    this.nodeWidth = this.snapSize(this.scrollNode.getLayoutBounds().getWidth());
                    this.nodeHeight = this.snapSize(this.scrollNode.getLayoutBounds().getHeight());
                    this.viewRect.getChildren().setAll((Node[])new Node[]{this.scrollNode});
                    this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
                    this.scrollNode.layoutBoundsProperty().addListener(this.boundsChangeListener);
                }
            }
            this.requestLayout();
        } else if (string == "FIT_TO_WIDTH") {
            this.requestLayout();
            this.viewRect.requestLayout();
        } else if (string == "FIT_TO_HEIGHT") {
            this.requestLayout();
            this.viewRect.requestLayout();
        } else if (string == "HBAR_POLICY") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            this.requestLayout();
        } else if (string == "VBAR_POLICY") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            this.requestLayout();
        } else if (string == "HVALUE") {
            this.hsb.setValue(((ScrollPane)this.getSkinnable()).getHvalue());
        } else if (string == "VVALUE") {
            this.vsb.setValue(((ScrollPane)this.getSkinnable()).getVvalue());
        } else if (string == "PREF_VIEWPORT_WIDTH") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        } else if (string == "PREF_VIEWPORT_HEIGHT") {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        if (bounds.getMaxX() > this.contentWidth) {
            d2 = this.contentWidth - bounds.getMaxX();
        }
        if (bounds.getMinX() < 0.0) {
            d2 = -bounds.getMinX();
        }
        if (bounds.getMaxY() > this.contentHeight) {
            d3 = this.contentHeight - bounds.getMaxY();
        }
        if (bounds.getMinY() < 0.0) {
            d3 = -bounds.getMinY();
        }
        double d4 = this.hsb.getValue();
        double d5 = this.vsb.getValue();
        if (d2 != 0.0) {
            d = -d2 * (this.hsb.getMax() - this.hsb.getMin()) / (this.nodeWidth - this.viewRect.getWidth());
            d = d < 0.0 ? (d -= this.hsb.getUnitIncrement()) : (d += this.hsb.getUnitIncrement());
            d4 = Utils.clamp(this.hsb.getMin(), this.hsb.getValue() + d, this.hsb.getMax());
            this.hsb.setValue(d4);
            bl = true;
        }
        if (d3 != 0.0) {
            d = -d3 * (this.vsb.getMax() - this.vsb.getMin()) / (this.nodeHeight - this.viewRect.getHeight());
            d = d < 0.0 ? (d -= this.vsb.getUnitIncrement()) : (d += this.vsb.getUnitIncrement());
            d5 = Utils.clamp(this.vsb.getMin(), this.vsb.getValue() + d, this.vsb.getMax());
            this.vsb.setValue(d5);
            bl = true;
        }
        if (bl) {
            this.requestLayout();
        }
    }

    public void hsbIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void hsbPageIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbPageDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void vsbIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    public void vsbPageIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbPageDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        if (((ScrollPane)this.getSkinnable()).getPrefViewportWidth() > 0.0) {
            double d2 = ((ScrollPane)this.getSkinnable()).getVbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS ? this.vsb.prefWidth(-1.0) : 0.0;
            return ((ScrollPane)this.getSkinnable()).getPrefViewportWidth() + d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return 100.0;
    }

    @Override
    protected double computePrefHeight(double d) {
        if (((ScrollPane)this.getSkinnable()).getPrefViewportHeight() > 0.0) {
            double d2 = ((ScrollPane)this.getSkinnable()).getHbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS ? this.hsb.prefHeight(-1.0) : 0.0;
            return ((ScrollPane)this.getSkinnable()).getPrefViewportHeight() + d2 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return 100.0;
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = this.corner.minWidth(-1.0);
        return d2 > 0.0 ? 3.0 * d2 : 36.0;
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = this.corner.minHeight(-1.0);
        return d2 > 0.0 ? 3.0 * d2 : 36.0;
    }

    @Override
    protected void layoutChildren() {
        ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
        this.vsb.setMin(scrollPane.getVmin());
        this.vsb.setMax(scrollPane.getVmax());
        this.hsb.setMin(scrollPane.getHmin());
        this.hsb.setMax(scrollPane.getHmax());
        this.contentWidth = scrollPane.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        this.contentHeight = scrollPane.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        double d = this.contentWidth + this.getPadding().getLeft() + this.getPadding().getRight();
        double d2 = this.contentHeight + this.getPadding().getTop() + this.getPadding().getBottom();
        this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
        this.computeScrollBarSize();
        this.vsbvis = this.determineVerticalSBVisible();
        this.hsbvis = this.determineHorizontalSBVisible();
        if (this.vsbvis) {
            d -= this.vsbWidth;
            if (!PlatformUtil.isEmbedded()) {
                this.contentWidth -= this.vsbWidth;
            }
        }
        if (this.hsbvis) {
            d2 -= this.hsbHeight;
            if (!PlatformUtil.isEmbedded()) {
                this.contentHeight -= this.hsbHeight;
            }
        }
        if (this.scrollNode != null && this.scrollNode.isResizable()) {
            if (this.vsbvis && this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
            } else if (this.hsbvis && !this.vsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.vsbvis = this.determineVerticalSBVisible();
                if (this.vsbvis) {
                    this.contentWidth -= this.vsbWidth;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            } else if (this.vsbvis && !this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.hsbvis = this.determineHorizontalSBVisible();
                if (this.hsbvis) {
                    this.contentHeight -= this.hsbHeight;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            }
        }
        double d3 = this.getInsets().getLeft() - this.getPadding().getLeft();
        double d4 = this.getInsets().getTop() - this.getPadding().getTop();
        this.vsb.setVisible(this.vsbvis);
        if (this.vsbvis) {
            if (this.getPadding().getRight() < 1.0) {
                this.vsb.resizeRelocate(this.snapPosition(scrollPane.getWidth() - (this.vsbWidth + (this.getInsets().getRight() - this.getPadding().getRight()))), this.snapPosition(d4), this.snapSize(this.vsbWidth), this.snapSize(d2));
            } else {
                this.vsb.resizeRelocate(this.snapPosition(scrollPane.getWidth() - (this.vsbWidth + 1.0 + (this.getInsets().getRight() - this.getPadding().getRight()))), this.snapPosition(d4), this.snapSize(this.vsbWidth) + 1.0, this.snapSize(d2));
            }
        }
        this.updateVerticalSB();
        this.hsb.setVisible(this.hsbvis);
        if (this.hsbvis) {
            if (this.getPadding().getBottom() < 1.0) {
                this.hsb.resizeRelocate(this.snapPosition(d3), this.snapPosition(scrollPane.getHeight() - (this.hsbHeight + (this.getInsets().getBottom() - this.getPadding().getBottom()))), this.snapSize(d), this.snapSize(this.hsbHeight));
            } else {
                this.hsb.resizeRelocate(this.snapPosition(d3), this.snapPosition(scrollPane.getHeight() - (this.hsbHeight + 1.0 + (this.getInsets().getBottom() - this.getPadding().getBottom()))), this.snapSize(d), this.snapSize(this.hsbHeight) + 1.0);
            }
        }
        this.updateHorizontalSB();
        this.viewRect.resize(this.snapSize(this.contentWidth), this.snapSize(this.contentHeight));
        this.resetClip();
        if (this.vsbvis && this.hsbvis) {
            this.corner.setVisible(true);
            double d5 = this.vsbWidth;
            double d6 = this.hsbHeight;
            if (this.getPadding().getRight() >= 1.0) {
                d5 += 1.0;
            }
            if (this.getPadding().getBottom() >= 1.0) {
                d6 += 1.0;
            }
            this.corner.resizeRelocate(this.snapPosition(this.vsb.getLayoutX()), this.snapPosition(this.hsb.getLayoutY()), this.snapSize(d5), this.snapSize(d6));
        } else {
            this.corner.setVisible(false);
        }
        scrollPane.setViewportBounds(new BoundingBox(this.snapPosition(this.viewRect.getLayoutX()), this.snapPosition(this.viewRect.getLayoutY()), this.snapSize(this.contentWidth), this.snapSize(this.contentHeight)));
    }

    private void computeScrollNodeSize(double d, double d2) {
        if (this.scrollNode != null) {
            if (this.scrollNode.isResizable()) {
                ScrollPane scrollPane = (ScrollPane)this.getSkinnable();
                Orientation orientation = this.scrollNode.getContentBias();
                if (orientation == null) {
                    this.nodeWidth = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                } else if (orientation == Orientation.HORIZONTAL) {
                    this.nodeWidth = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(this.nodeWidth), this.scrollNode.minHeight(this.nodeWidth), this.scrollNode.maxHeight(this.nodeWidth)));
                } else {
                    this.nodeHeight = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToHeight() ? d2 : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                    this.nodeWidth = this.snapSize(com.sun.javafx.scene.control.skin.Utils.boundedSize(scrollPane.isFitToWidth() ? d : this.scrollNode.prefWidth(this.nodeHeight), this.scrollNode.minWidth(this.nodeHeight), this.scrollNode.maxWidth(this.nodeHeight)));
                }
            } else {
                this.nodeWidth = this.snapSize(this.scrollNode.getLayoutBounds().getWidth());
                this.nodeHeight = this.snapSize(this.scrollNode.getLayoutBounds().getHeight());
            }
        }
    }

    private boolean determineHorizontalSBVisible() {
        double d = ((ScrollPane)this.getSkinnable()).getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        if (PlatformUtil.isEmbedded()) {
            return this.tempVisibility && this.nodeWidth > d;
        }
        return ((ScrollPane)this.getSkinnable()).getHbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.NEVER) ? false : (((ScrollPane)this.getSkinnable()).getHbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) ? true : (((ScrollPane)this.getSkinnable()).isFitToWidth() && this.scrollNode != null && this.scrollNode.isResizable() ? this.nodeWidth > d && this.scrollNode.minWidth(-1.0) > d : this.nodeWidth > d));
    }

    private boolean determineVerticalSBVisible() {
        double d = ((ScrollPane)this.getSkinnable()).getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (PlatformUtil.isEmbedded()) {
            return this.tempVisibility && this.nodeHeight > d;
        }
        return ((ScrollPane)this.getSkinnable()).getVbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.NEVER) ? false : (((ScrollPane)this.getSkinnable()).getVbarPolicy().equals((Object)ScrollPane.ScrollBarPolicy.ALWAYS) ? true : (((ScrollPane)this.getSkinnable()).isFitToHeight() && this.scrollNode != null && this.scrollNode.isResizable() ? this.nodeHeight > d && this.scrollNode.minHeight(-1.0) > d : this.nodeHeight > d));
    }

    private void computeScrollBarSize() {
        this.vsbWidth = this.snapSize(this.vsb.prefWidth(-1.0));
        if (this.vsbWidth == 0.0) {
            this.vsbWidth = 12.0;
        }
        this.hsbHeight = this.snapSize(this.hsb.prefHeight(-1.0));
        if (this.hsbHeight == 0.0) {
            this.hsbHeight = 12.0;
        }
    }

    private void updateHorizontalSB() {
        double d = this.nodeWidth * (this.hsb.getMax() - this.hsb.getMin());
        if (d > 0.0) {
            this.hsb.setVisibleAmount(this.contentWidth / d);
            this.hsb.setBlockIncrement(0.9 * this.hsb.getVisibleAmount());
            this.hsb.setUnitIncrement(0.1 * this.hsb.getVisibleAmount());
        } else {
            this.hsb.setVisibleAmount(0.0);
            this.hsb.setBlockIncrement(0.0);
            this.hsb.setUnitIncrement(0.0);
        }
        if (this.hsb.isVisible()) {
            this.updatePosX();
        } else if (this.nodeWidth > this.contentWidth) {
            this.updatePosX();
        } else {
            this.viewRect.setLayoutX(this.getInsets().getLeft());
        }
    }

    private void updateVerticalSB() {
        double d = this.nodeHeight * (this.vsb.getMax() - this.vsb.getMin());
        if (d > 0.0) {
            this.vsb.setVisibleAmount(this.contentHeight / d);
            this.vsb.setBlockIncrement(0.9 * this.vsb.getVisibleAmount());
            this.vsb.setUnitIncrement(0.1 * this.vsb.getVisibleAmount());
        } else {
            this.vsb.setVisibleAmount(0.0);
            this.vsb.setBlockIncrement(0.0);
            this.vsb.setUnitIncrement(0.0);
        }
        if (this.vsb.isVisible()) {
            this.updatePosY();
        } else if (this.nodeHeight > this.contentHeight) {
            this.updatePosY();
        } else {
            this.viewRect.setLayoutY(this.getInsets().getTop());
        }
    }

    private double updatePosX() {
        this.viewRect.setLayoutX(this.snapPosition(this.getInsets().getLeft() - this.posX / (this.hsb.getMax() - this.hsb.getMin()) * (this.nodeWidth - this.contentWidth)));
        ((ScrollPane)this.getSkinnable()).setHvalue(Utils.clamp(((ScrollPane)this.getSkinnable()).getHmin(), this.posX, ((ScrollPane)this.getSkinnable()).getHmax()));
        this.resetClip();
        return this.posX;
    }

    private double updatePosY() {
        this.viewRect.setLayoutY(this.snapPosition(this.getInsets().getTop() - this.posY / (this.vsb.getMax() - this.vsb.getMin()) * (this.nodeHeight - this.contentHeight)));
        ((ScrollPane)this.getSkinnable()).setVvalue(Utils.clamp(((ScrollPane)this.getSkinnable()).getVmin(), this.posY, ((ScrollPane)this.getSkinnable()).getVmax()));
        this.resetClip();
        return this.posY;
    }

    private void resetClip() {
        this.clipRect.setWidth(this.snapSize(this.contentWidth));
        this.clipRect.setHeight(this.snapSize(this.contentHeight));
        this.clipRect.relocate(this.snapPosition(this.getInsets().getLeft() - this.viewRect.getLayoutX()), this.snapPosition(this.getInsets().getTop() - this.viewRect.getLayoutY()));
    }

    void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ScrollPaneSkin.this.tempVisibility = true;
                }
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ScrollPaneSkin.this.tempVisibility = false;
                    ScrollPaneSkin.this.requestLayout();
                }
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    void startContentsToViewport() {
        double d = this.posX;
        double d2 = this.posY;
        double d3 = ((ScrollPane)this.getSkinnable()).getHmax() - ((ScrollPane)this.getSkinnable()).getHmin();
        double d4 = ((ScrollPane)this.getSkinnable()).getVmax() - ((ScrollPane)this.getSkinnable()).getVmin();
        this.setContentPosX(this.posX);
        this.setContentPosY(this.posY);
        if (this.posY > ((ScrollPane)this.getSkinnable()).getVmax()) {
            d2 = ((ScrollPane)this.getSkinnable()).getVmax();
        } else if (this.posY < ((ScrollPane)this.getSkinnable()).getVmin()) {
            d2 = ((ScrollPane)this.getSkinnable()).getVmin();
        }
        if (this.posX > ((ScrollPane)this.getSkinnable()).getHmax()) {
            d = ((ScrollPane)this.getSkinnable()).getHmax();
        } else if (this.posX < ((ScrollPane)this.getSkinnable()).getHmin()) {
            d = ((ScrollPane)this.getSkinnable()).getHmin();
        }
        if (!PlatformUtil.isEmbedded()) {
            this.startSBReleasedAnimation();
        }
        if (this.contentsToViewTimeline != null) {
            this.contentsToViewTimeline.stop();
        }
        this.contentsToViewTimeline = new Timeline();
        this.contentsToViewKF1 = new KeyFrame(Duration.millis(50.0), new KeyValue[0]);
        this.contentsToViewKF2 = new KeyFrame(Duration.millis(150.0), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                ScrollPaneSkin.this.requestLayout();
            }
        }, new KeyValue(this.contentPosX, d), new KeyValue(this.contentPosY, d2));
        this.contentsToViewKF3 = new KeyFrame(Duration.millis(1500.0), new KeyValue[0]);
        this.contentsToViewTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.contentsToViewKF1, this.contentsToViewKF2, this.contentsToViewKF3});
        this.contentsToViewTimeline.playFromStart();
    }

    private void setContentPosX(double d) {
        this.contentPosXProperty().set(d);
    }

    private double getContentPosX() {
        return this.contentPosX == null ? 0.0 : this.contentPosX.get();
    }

    private DoubleProperty contentPosXProperty() {
        if (this.contentPosX == null) {
            this.contentPosX = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ScrollPaneSkin.this.hsb.setValue(ScrollPaneSkin.this.getContentPosX());
                    ScrollPaneSkin.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return ScrollPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "contentPosX";
                }
            };
        }
        return this.contentPosX;
    }

    private void setContentPosY(double d) {
        this.contentPosYProperty().set(d);
    }

    private double getContentPosY() {
        return this.contentPosY == null ? 0.0 : this.contentPosY.get();
    }

    private DoubleProperty contentPosYProperty() {
        if (this.contentPosY == null) {
            this.contentPosY = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ScrollPaneSkin.this.vsb.setValue(ScrollPaneSkin.this.getContentPosY());
                    ScrollPaneSkin.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return ScrollPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "contentPosY";
                }
            };
        }
        return this.contentPosY;
    }
}

