/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class FontUnits {

    public static enum Style {
        NORMAL(FontPosture.REGULAR),
        ITALIC(FontPosture.ITALIC),
        OBLIQUE(FontPosture.ITALIC),
        INHERIT;

        FontPosture posture;

        private Style() {
            this.posture = FontPosture.REGULAR;
        }

        private Style(FontPosture fontPosture) {
            this.posture = fontPosture;
        }

        public FontPosture toFontPosture() {
            return this.posture;
        }

        public String toString() {
            return this.posture.toString();
        }
    }

    public static enum Weight {
        NORMAL(FontWeight.NORMAL),
        BOLD(FontWeight.BOLD),
        BOLDER,
        LIGHTER,
        INHERIT,
        SCALE_100(FontWeight.THIN),
        SCALE_200(FontWeight.EXTRA_LIGHT),
        SCALE_300(FontWeight.LIGHT),
        SCALE_400(FontWeight.NORMAL),
        SCALE_500(FontWeight.MEDIUM),
        SCALE_600(FontWeight.SEMI_BOLD),
        SCALE_700(FontWeight.BOLD),
        SCALE_800(FontWeight.EXTRA_BOLD),
        SCALE_900(FontWeight.BLACK);

        FontWeight weight;

        private Weight() {
            this.weight = FontWeight.NORMAL;
        }

        private Weight(FontWeight fontWeight) {
            this.weight = fontWeight;
        }

        public static Weight toWeight(FontWeight fontWeight) {
            Weight weight = null;
            weight = FontWeight.THIN == fontWeight ? SCALE_100 : (FontWeight.EXTRA_LIGHT == fontWeight ? SCALE_200 : (FontWeight.LIGHT == fontWeight ? SCALE_300 : (FontWeight.NORMAL == fontWeight ? SCALE_400 : (FontWeight.MEDIUM == fontWeight ? SCALE_500 : (FontWeight.SEMI_BOLD == fontWeight ? SCALE_600 : (FontWeight.BOLD == fontWeight ? SCALE_700 : (FontWeight.EXTRA_BOLD == fontWeight ? SCALE_800 : (FontWeight.BLACK == fontWeight ? SCALE_900 : SCALE_400))))))));
            return weight;
        }

        public FontWeight toFontWeight() {
            return this.weight;
        }

        public String toString() {
            return this.weight.toString();
        }

        public Weight bolder() {
            Weight weight = NORMAL;
            switch (this) {
                case SCALE_100: {
                    weight = SCALE_200;
                    break;
                }
                case SCALE_200: {
                    weight = SCALE_300;
                    break;
                }
                case SCALE_300: {
                    weight = SCALE_400;
                    break;
                }
                default: {
                    weight = SCALE_500;
                    break;
                }
                case SCALE_500: {
                    weight = SCALE_600;
                    break;
                }
                case SCALE_600: {
                    weight = SCALE_700;
                    break;
                }
                case BOLD: 
                case SCALE_700: {
                    weight = SCALE_800;
                    break;
                }
                case SCALE_800: 
                case SCALE_900: {
                    weight = SCALE_900;
                }
            }
            return weight;
        }

        public Weight lighter() {
            Weight weight = NORMAL;
            switch (this) {
                case SCALE_100: 
                case SCALE_200: {
                    weight = SCALE_100;
                    break;
                }
                case SCALE_300: {
                    weight = SCALE_200;
                    break;
                }
                default: {
                    weight = SCALE_300;
                    break;
                }
                case SCALE_500: {
                    weight = SCALE_400;
                    break;
                }
                case SCALE_600: {
                    weight = SCALE_500;
                    break;
                }
                case BOLD: 
                case SCALE_700: {
                    weight = SCALE_600;
                    break;
                }
                case SCALE_800: {
                    weight = SCALE_700;
                    break;
                }
                case SCALE_900: {
                    weight = SCALE_800;
                }
            }
            return weight;
        }
    }
}

