/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Graphics;
import com.sun.prism.impl.Disposer;

public class PresentingPainter
extends ViewPainter
implements Runnable {
    private ViewScene vs;

    protected PresentingPainter(ViewScene viewScene, PrismPen prismPen) {
        super(viewScene, prismPen);
        this.vs = viewScene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean bl;
            assert (!renderLock.isHeldByCurrentThread());
            renderLock.lock();
            this.valid = this.validateStageGraphics();
            if (!this.valid) {
                if (this.factory == null || !this.factory.isDeviceReady()) {
                    this.scene.entireSceneNeedsRepaint();
                }
                if (verbose) {
                    System.err.println("PresentingPainter: validateStageGraphics failed");
                }
                return;
            }
            if (this.view != null) {
                this.pen.begin();
            }
            boolean bl2 = bl = this.presentable == null || this.penWidth != this.viewWidth || this.penHeight != this.viewHeight;
            if (bl && (this.presentable == null || this.presentable.recreateOnResize())) {
                this.context = this.factory.createRenderingContext(this.vs.getPlatformView());
            }
            this.context.begin();
            if (bl) {
                if (this.presentable == null || this.presentable.recreateOnResize()) {
                    this.disposePresentable();
                    this.presentable = this.factory.createPresentable(this.vs.getPlatformView());
                    bl = false;
                }
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
            }
            if (this.presentable != null) {
                Graphics graphics = this.presentable.createGraphics();
                if (graphics != null) {
                    if (bl) {
                        graphics.reset();
                    }
                    this.paintImpl(graphics);
                }
                if (!this.presentable.prepare(null)) {
                    this.disposePresentable();
                    this.scene.entireSceneNeedsRepaint();
                    return;
                }
                if (!this.liveRepaint.get() && collector.toolkit().isVsyncEnabled()) {
                    collector.releaseScene(this.scene);
                }
                if (!this.presentable.present()) {
                    this.disposePresentable();
                    this.scene.entireSceneNeedsRepaint();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.valid && this.context != null) {
                Disposer.cleanUp();
                this.context.end();
            }
            if (this.valid && this.view != null && !this.view.isClosed()) {
                this.pen.end();
            }
            this.pen.getPainting().set(false);
            renderLock.unlock();
        }
    }
}

