/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.WinRegistryUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WinAppAssociationWriter
implements AppAssociationWriter {
    public WinAppAssociationWriter(LocalApplicationProperties localApplicationProperties) {
    }

    private void restoreAssociationRegistration(BackupAssociation backupAssociation, int n) {
        try {
            String string = backupAssociation.getCurMimeType();
            if (!backupAssociation.getCurMimeTypeExisted()) {
                if (string != null) {
                    WinRegistryUtil.removeMimeType(string, n);
                }
            } else {
                String string2 = backupAssociation.getBackupFileExt();
                if (string2 != null) {
                    WinRegistryUtil.setFileExtByMimeType(string2, string, n);
                }
            }
            int n2 = backupAssociation.getNumFileExts();
            for (int i = 0; i < n2; ++i) {
                String string3;
                String string4 = backupAssociation.getCurFileExt(i);
                if (!backupAssociation.getCurFileExtExisted(i)) {
                    if (string4 == null) continue;
                    WinRegistryUtil.removeFileExt(string4, n);
                    continue;
                }
                String string5 = backupAssociation.getBackupMimeType(i);
                if (string5 != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(string5, string4, n);
                }
                if ((string3 = backupAssociation.getBackupClassID(i)) == null) continue;
                WinRegistryUtil.setClassIDByFileExt(string4, string3, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    private void restoreAssociationUnregistration(BackupAssociation backupAssociation, int n) {
        try {
            String string = backupAssociation.getCurMimeType();
            if (backupAssociation.getCurMimeTypeExisted()) {
                WinRegistryUtil.addMimeType(string, n);
                String string2 = backupAssociation.getBackupFileExt();
                if (string2 != null) {
                    WinRegistryUtil.setFileExtByMimeType(string2, string, n);
                }
            }
            int n2 = backupAssociation.getNumFileExts();
            for (int i = 0; i < n2; ++i) {
                String string3 = backupAssociation.getCurFileExt(i);
                if (!backupAssociation.getCurFileExtExisted(i)) continue;
                WinRegistryUtil.addFileExt(string3, n);
                String string4 = backupAssociation.getBackupMimeType(i);
                String string5 = backupAssociation.getBackupClassID(i);
                if (string4 != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(string4, string3, n);
                }
                if (string5 == null) continue;
                WinRegistryUtil.setClassIDByFileExt(string3, string5, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (association.getActionList() != null) {
            bl = association.getActionList().isEmpty();
        }
        if (association.getFileExtList() != null) {
            bl2 = association.getFileExtList().isEmpty();
        }
        if (!(bl3 = bl2 && association.getMimeType() == null ? false : (association.getDescription() != null || association.getIconFileName() != null || !bl ? !bl2 : true))) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
        boolean bl = true;
        if (association.getFileExtList() != null) {
            bl = association.getFileExtList().isEmpty();
        }
        if (association.getMimeType() == null && bl) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public boolean isAssociationExist(Association association, int n) {
        String string;
        boolean bl;
        String string2 = association.getMimeType();
        Iterator iterator = association.getFileExtList() != null ? association.getFileExtList().iterator() : null;
        if (iterator != null) {
            bl = true;
            while (bl && iterator.hasNext()) {
                string = (String)iterator.next();
                if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(string)) continue;
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        iterator = association.getFileExtList() != null ? association.getFileExtList().iterator() : null;
        if (string2 == null && iterator == null) {
            return false;
        }
        if (string2 == null && iterator != null) {
            bl = true;
            while (bl && iterator.hasNext()) {
                string = (String)iterator.next();
                if (WinRegistryUtil.isFileExtExist(string, n)) continue;
                bl = false;
            }
            return bl;
        }
        if (string2 != null && iterator == null) {
            return WinRegistryUtil.isMimeTypeExist(string2, n);
        }
        bl = WinRegistryUtil.isMimeTypeExist(string2, n);
        while (bl && iterator.hasNext()) {
            string = (String)iterator.next();
            String string3 = WinRegistryUtil.getMimeTypeByFileExt(string, n);
            String string4 = WinRegistryUtil.getFileExtByMimeType(string2, n);
            bl = WinRegistryUtil.isFileExtExist(string, n) && (string4 == null ? string == null : string4.contains(string)) && (string2 == null ? string3 == null : string2.equals(string3));
        }
        return bl;
    }

    public void registerAssociation(Association association, int n) throws RegisterFailedException {
        boolean bl = false;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("98") != -1 || string.indexOf("me") != -1 || string.indexOf("nt") != -1) {
            bl = true;
        }
        if (bl) {
            n = 2;
        }
        BackupAssociation backupAssociation = new BackupAssociation(association, n);
        String string2 = backupAssociation.getCurMimeType();
        String string3 = association.getDescription();
        String string4 = association.getIconFileName();
        List list = association.getActionList();
        boolean bl2 = backupAssociation.getCurMimeTypeExisted();
        try {
            int n2 = backupAssociation.getNumFileExts();
            for (int i = 0; i < n2; ++i) {
                String string5 = backupAssociation.getCurFileExt(i);
                boolean bl3 = backupAssociation.getCurFileExtExisted(i);
                if (string2 == null && string5 != null) {
                    WinRegistryUtil.addFileExt(string5, n);
                    if (string3 != null) {
                        WinRegistryUtil.setDescriptionByFileExt(string3, string5, n);
                    }
                    if (string4 != null) {
                        WinRegistryUtil.setIconFileNameByFileExt(string4, string5, n);
                    }
                    if (list != null) {
                        WinRegistryUtil.setActionListByFileExt(list, string5, n);
                    }
                    WinRegistryUtil.markGeneratorByFileExt(string5, n);
                    continue;
                }
                if (string2 != null && string5 == null) {
                    WinRegistryUtil.addMimeType(string2, n);
                    continue;
                }
                if (string2 == null || string5 == null) continue;
                if (!bl2) {
                    WinRegistryUtil.addMimeType(string2, n);
                }
                if (!bl3) {
                    WinRegistryUtil.addFileExt(string5, n);
                }
                if (string3 != null) {
                    WinRegistryUtil.setDescriptionByFileExt(string3, string5, n);
                }
                if (string4 != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(string4, string5, n);
                }
                if (list != null) {
                    WinRegistryUtil.setActionListByFileExt(list, string5, n);
                }
                WinRegistryUtil.markGeneratorByFileExt(string5, n);
                WinRegistryUtil.addMutualRef(string5, string2, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            this.restoreAssociationRegistration(backupAssociation, n);
            throw registerFailedException;
        }
    }

    public void unregisterAssociation(Association association, int n) throws RegisterFailedException {
        boolean bl = false;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("98") != -1 || string.indexOf("me") != -1 || string.indexOf("nt") != -1) {
            bl = true;
        }
        if (bl) {
            n = 2;
        }
        BackupAssociation backupAssociation = new BackupAssociation(association, n);
        String string2 = backupAssociation.getCurMimeType();
        boolean bl2 = backupAssociation.getCurMimeTypeExisted();
        try {
            int n2 = backupAssociation.getNumFileExts();
            for (int i = 0; i < n2; ++i) {
                String string3 = backupAssociation.getCurFileExt(i);
                boolean bl3 = backupAssociation.getCurFileExtExisted(i);
                if (bl2) {
                    WinRegistryUtil.removeMimeType(string2, n);
                }
                if (!bl3) continue;
                WinRegistryUtil.removeFileExt(string3, n);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            this.restoreAssociationUnregistration(backupAssociation, n);
            throw registerFailedException;
        }
    }

    protected class BackupAssociation {
        private String curMimeType;
        private List fileExts;
        private boolean curMimeTypeExisted;
        private boolean[] fileExtExisted;
        private String[] backupMimeType;
        private String[] backupClassID;
        private String backupFileExt;

        private BackupAssociation() {
        }

        protected BackupAssociation(Association association, int n) {
            this.curMimeType = association.getMimeType();
            List list = association.getFileExtList();
            if (list != null) {
                this.fileExts = new ArrayList();
                this.fileExts.addAll(list);
            }
            this.curMimeTypeExisted = this.curMimeType != null ? WinRegistryUtil.isMimeTypeExist(this.curMimeType, n) : false;
            if (this.fileExts != null) {
                int n2 = this.fileExts.size();
                this.fileExtExisted = new boolean[n2];
                this.backupClassID = new String[n2];
                this.backupMimeType = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    String string = (String)this.fileExts.get(i);
                    this.fileExtExisted[i] = WinRegistryUtil.isFileExtExist(string, n);
                    this.backupClassID[i] = WinRegistryUtil.getClassIDByFileExt(string, n);
                    this.backupMimeType[i] = WinRegistryUtil.getMimeTypeByFileExt(string, n);
                }
            } else {
                this.fileExtExisted = null;
            }
            if (this.curMimeTypeExisted) {
                this.backupFileExt = WinRegistryUtil.getFileExtByMimeType(this.curMimeType, n);
            }
        }

        protected String getCurMimeType() {
            return this.curMimeType;
        }

        protected String getCurFileExt(int n) {
            return (String)this.fileExts.get(n);
        }

        int getNumFileExts() {
            return this.fileExts == null ? 0 : this.fileExts.size();
        }

        protected boolean getCurMimeTypeExisted() {
            return this.curMimeTypeExisted;
        }

        protected boolean getCurFileExtExisted(int n) {
            return this.fileExtExisted[n];
        }

        protected String getBackupMimeType(int n) {
            return this.backupMimeType[n];
        }

        protected String getBackupClassID(int n) {
            return this.backupClassID[n];
        }

        protected String getBackupFileExt() {
            return this.backupFileExt;
        }
    }
}

