package br.com.bancooriginal.cyberbank.dto;

import java.io.Serializable;

/**
 * Classe que representa um lancamento em conta corrente servindo para
 * criar VOs (Vale Objects)
 * @author filipe.sa
 *
 */
public class Lancamento implements ILancamento, Serializable {

	private static final long serialVersionUID = -2606161510065202411L;
	
	private String numConta;
	private String transacao;
	private String motivo;
	private String valor;
	private String data;
	private String comentario;
	private String categoria;
	private String valorCheque24;
	private String valorCheque48;
	private String numDocumento;
	private Boolean reversalFlag = false;
	private String reversalNumber;
	
	private String resposta;
	private String errorList;
	
	
	
	public String getNumConta() {
		return numConta;
	}
	public void setNumConta(String numConta) {
		this.numConta = numConta;
	}
	
	public String getTransacao() {
		return transacao;
	}
	public void setTransacao(String transacao) {
		this.transacao = transacao;
	}

	public String getMotivo() {
		return motivo;
	}
	public void setMotivo(String motivo) {
		this.motivo = motivo;
	}
	
	public String getValor() {
		return valor;
	}
	public void setValor(String valor) {
		this.valor = valor;
	}
	public void setValorDouble(Double valor) {
		this.valor = valor.toString();
	}
	
	public String getData() {
		return data;
	}
	public String getDataParaMensagem() {
		
		if(data != null && data.length() == 10){
			String dataParaMensagem = "";
			String[] dataArray = data.split("/");
			if(dataArray.length == 3){
				//criando data no formato yyyyMMddHHMMsshhh
				dataParaMensagem = dataArray[2];
				dataParaMensagem += dataArray[1];
				dataParaMensagem += dataArray[0];
				dataParaMensagem += "000000000";
				return dataParaMensagem;
			}
		}
		
		return null;
	}
	
	public void setData(String data) {
		this.data = data;
	}
	
	public String getComentario() {
		return comentario;
	}
	public void setComentario(String comentario) {
		this.comentario = comentario;
	}
	
	public String getCategoria() {
		return categoria;
	}
	public void setCategoria(String categoria) {
		this.categoria = categoria;
	}
	
	public String getValorCheque24() {
		return valorCheque24;
	}
	public void setValorCheque24(String valorCheque24) {
		this.valorCheque24 = valorCheque24;
	}
	
	public String getValorCheque48() {
		return valorCheque48;
	}
	public void setValorCheque48(String valorCheque48) {
		this.valorCheque48 = valorCheque48;
	}
	
	public String getNumDocumento() {
		return numDocumento;
	}
	public void setNumDocumento(String numDocumento) {
		this.numDocumento = numDocumento;
	}
	public String getResposta() {
		return resposta;
	}
	public void setResposta(String resposta) {
		this.resposta = resposta;
	}
	public String getErrorList() {
		return errorList;
	}
	public void setErrorList(String errorList) {
		this.errorList = errorList;
	}
	public Boolean getReversalFlag() {
		return reversalFlag;
	}
	public void setReversalFlag(Boolean reversalFlag) {
		this.reversalFlag = reversalFlag;
	}
	public String getReversalNumber() {
		return reversalNumber;
	}
	public void setReversalNumber(String reversalNumber) {
		this.reversalNumber = reversalNumber;
	}

	
}
