package br.com.bancooriginal.cyberbank.awt.validators;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

/**
 * Validador de campos decimais.
 * @author filipe.sa
 *
 */
public class DecimalVerifier extends InputVerifier implements ActionListener{

	private int inteiros;
	private int decimais;
	private boolean obrigatorio;
	
	/**
	 * Contrutor que recebe a quantidade de digitos inteiros e decimais possiveis
	 * para o campo de input, alem de receber um boleano que indica se o campo eh obrigatorio
	 * ou nao.
	 * @param inteiros
	 * @param decimais
	 * @param obrigatorio
	 */
	public DecimalVerifier(int inteiros, int decimais, boolean obrigatorio){
		this.inteiros=inteiros;
		this.decimais=decimais;
		this.obrigatorio=obrigatorio;
	}

	@Override
	public boolean verify(JComponent input) {
		
		JTextField textField = ((JTextField) input);
		
		//Caso o campo seja obrigatorio e nao seja preenchido o campo ficara vermelho
		if(obrigatorio && (null == textField.getText() || "".equals(textField.getText().trim()))){
			textField.setBackground(Color.RED);
			textField.setText("Campo obrigatório");
			return false;
		}
		
		if(!textField.getText().matches("^\\d{1,"+inteiros+"}+(\\.\\d{0,"+decimais+"})?$")){

			textField.setBackground(Color.RED);
			return false;
			
		}
		
		textField.setBackground(Color.WHITE);
		return true;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		
		JTextField source = (JTextField)e.getSource();
        shouldYieldFocus(source);
        source.selectAll();
		
	}

}
