package br.com.bancooriginal.cyberbank.awt.component;

import javax.swing.table.AbstractTableModel;

/**
 * Clase que serve para criar a tabela com as instrucoes de preenchimento
 * da parametrizacao.
 * 
 * @author filipe.sa
 *
 */
public class InstrucoesParametrizacaoModel extends AbstractTableModel {
	
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private String[] columnNames = {"CREDENCIAL", "TIPO DE DADO", "DESCRIÇÃO", "OBSERVAÇÃO"};
	
	private Object[][] data = {
		    {"institutionId", "Number(4,0)", "É o código da instituição." ,"Deve informar \"1111\"."},
		    {"branchId", "Number(9,0)", "É o código da agência que está efetuando a movimentação.", "Deve informar \"1\"."},
		    {"channelId", "Fixo", "Canal", "Deve informar \"20\"."},
		    {"terminalId", "Fixo", "Terminal", "Deve informar \"ws\"."},
		    {"parityCurrencyCodeId", "Number(4,0)", "Moeda de paridade. É a moeda que o banco movimenta.", "Deve informar \"212\"."},
		    {"parityQuotationTypeNemotecnic", "Number(9,0)", "Tipo de cotação usada em conversão (compra / venda de moeda estrangeira)", "Deve informar \"0\"."},
		    {"localCountryId", "Number(9,0)", "Código do país.", "Deve informar \"55\"."},
		    {"localCurrencyCodeId", "Number(4,0)", "Moeda que o banco movimenta.", "Deve informar \"1\"."},
		    {"bankId", "Number(9,0)", "É o código do banco.", "Deve informar \"212\"."},
		    {"userId", "Varchar(25 bytes)", "Id do usuário.", "Informar \"Simulador\" (usuário cadastrado e autorizado a transacionar na Technisys)."},
		    {"sourceDate", "Date", "Data do módulo", "Ex.: 20101010101010000. Deve passar a data do e-bank. Formato: AAAAMMDDHHMMSSCCC"},
		    {"sourceTime", "Date", "Hora do sistema", "Ex.: 20101010101010000. Formato: AAAAMMDDHHMMSSCCC"},
		    {"businessDate", "Date", "Data de negócio", "Ex.: 200902030000000. Deve passar a data do e-bank. Formato: AAAAMMDDHHMMSSCCC"},
		    {"msgTypeId", "Fixo", "Tipo de mensagem", "Deve informar \"200\"."},
		    {"originBranchId", "Number(9,0)", "É a agência de origem do movimento.", "Deve informar \"1\"."},
		    {"dependencyId", "Number(9,0)", "É o número da agência.", "Deve informar \"1\"."}
		};


    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return data.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return data[row][col];
    }

    public Class<?> getColumnClass(int c) {
        return getValueAt(0, c).getClass();
        
    }

}
