package br.com.bancooriginal.cyberbank.enums;

import br.com.bancooriginal.cyberbank.util.CBUtil;

/**
 * Enumeracao com os valores da combo de acoes da pagina inicial.
 * 
 * @author filipe.sa
 * @author diego.dias
 *
 */
public enum ComboControllerType {
	
	SELECT					(CBUtil.getMensagem("messages.cyberbank.combobox.item.select")),
	PARAMETRIZACAO			(CBUtil.getMensagem("messages.cyberbank.combobox.item.param")),
	LANCAMENTO_CC			(CBUtil.getMensagem("messages.cyberbank.combobox.item.lancamento")),
	GERAR_SESSIONID	        (CBUtil.getMensagem("messages.cyberbank.combobox.item.sessionid")),
	OPERACAO_AUTORIZADOR	(CBUtil.getMensagem("messages.cyberbank.combobox.item.autorizador"));
	
	private final String label;
	
	private ComboControllerType(String label){
		this.label = label;
	}
	
	public String getLabel(){
		return this.label;
	}
	
	public String toString(){
		return getLabel();
	}
	

}
