package br.com.bancooriginal.cyberbank.awt.validators;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import br.com.bancooriginal.cyberbank.dto.ILancamento;
import br.com.bancooriginal.cyberbank.dto.Lancamento;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.ValidationUtils;

/**
 * Classe que valida os campos do lancamento em conta corrente.
 * @author filipe.sa
 *
 */
public class LancamentoValidator extends AbstractValueModel implements Validator<Lancamento>, ILancamento {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private ILancamento lancamento = new Lancamento();

	@Override
	public Object getValue() {
		return this;
	}

	@Override
	public void setValue(Object arg0) {
		//nunca utilizado
	}

	public ILancamento getILancamento(){
		return lancamento;
	}
	
	public void setILancamento(final ILancamento lancamento){
		this.lancamento = lancamento;
	}
	

	@Override
	public ValidationResult validate(Lancamento lancamento) {
		
		return new ValidationResult();
	}
	
	public ValidationResult validate() {
		
		ValidationResult result = new ValidationResult();
		//ValidationUtils
		if (null == lancamento.getNumConta() || "".equals(lancamento.getNumConta().trim())) {
		      result.addError("<p>O Número da Conta é obrigatório! </p>");
		}else{
			
			if(!ValidationUtils.hasMaximumLength(lancamento.getNumConta(), 25)){
				result.addError("<p>O Número da Conta pode ter no máximo 25 caracteres! </p>");
			}
			
		}
		
		if (null == lancamento.getTransacao() || "".equals(lancamento.getTransacao().trim())) {
		      result.addError("<p>A Transação é obrigatória! </p>");
		}else{
			
			if(!ValidationUtils.isNumeric(lancamento.getTransacao())){
				result.addError("<p>A Transação só pode conter números! </p>");
			}
			if(!ValidationUtils.hasMaximumLength(lancamento.getTransacao(), 9)){
				result.addError("<p>A Transação pode ter no máximo 9 números! </p>");
			}
			
		}
		
		if (null == lancamento.getMotivo() || "".equals(lancamento.getMotivo().trim())) {
		      result.addError("<p>O Motivo é obrigatório! </p>");
		}else{
			
			if(!ValidationUtils.isNumeric(lancamento.getMotivo())){
				result.addError("<p>O motivo só pode conter números! </p>");
			}
			if(!ValidationUtils.hasMaximumLength(lancamento.getMotivo(), 9)){
				result.addError("<p>O motivo pode ter no máximo 9 números! </p>");
			}
			
		}
		
		if (null == lancamento.getValor() || "".equals(lancamento.getValor().trim())) {
		      result.addError("<p>O Valor é obrigatório! </p>");
		}else{
			
			if(!lancamento.getValor().matches("^\\d{1,20}+(\\,\\d{0,5})?$")){
				result.addError("<p>O valor deve ser numérico com, no máximo,<br>" +
						" 20 dígitos inteiros e 5 decimais. </p>");
			}
			
		}
		
		if (null == lancamento.getData() || "".equals(lancamento.getData().replace("/", "").trim())) {
		      result.addError("<p>A Data é obrigatória! </p>");
		}else{
			SimpleDateFormat sd = new SimpleDateFormat("dd/MM/yyyy");
			try {
				sd.setLenient(false);
				sd.parse(lancamento.getData());
			} catch (ParseException e) {
				result.addError("<p>Data inválida! Deve seguir o padrão dd/mm/aaaa. </p>");
			}
		}
		
//		if(null != lancamento.getComentario() || !"".equals(lancamento.getComentario().trim())){
//			
//		}
//		
		if(null != lancamento.getCategoria()){
					
			if(!ValidationUtils.isNumeric(lancamento.getCategoria())){
				result.addError("<p>Categoria só pode conter números! </p>");
			}
			if(!ValidationUtils.hasMaximumLength(lancamento.getReversalNumber(), 25)){
				result.addError("<p>Categoria pode ter no máximo 9 números! </p>");
			}

		}
		
		if(null != lancamento.getValorCheque24() && !"".equals(lancamento.getValorCheque24().trim())){
			if(!lancamento.getValorCheque24().matches("^\\d{1,20}+(\\,\\d{0,5})?$")){
				result.addError("<p>O valor Cheque 24 horas deve ser numérico com, no máximo,<br>" +
						" 20 dígitos inteiros e 5 decimais. </p>");
			}
		}
		
		if(null != lancamento.getValorCheque48() && !"".equals(lancamento.getValorCheque48().trim())){
			if(!lancamento.getValorCheque48().matches("^\\d{1,20}+(\\,\\d{0,5})?$")){
				result.addError("<p>O valor Cheque 48 horas deve ser numérico com, no máximo,<br>" +
						" 20 dígitos inteiros e 5 decimais. </p>");
			}
		}
		
		if (null == lancamento.getNumDocumento() || "".equals(lancamento.getNumDocumento().trim())) {
		      result.addError("<p>O número do documento é obrigatório! </p>");
		      
		      	if(!ValidationUtils.isNumeric(lancamento.getNumDocumento())){
					result.addError("<p>O número do documento só pode conter números! </p>");
		      	}
			  	if(!ValidationUtils.hasMaximumLength(lancamento.getReversalNumber(), 25)){
					result.addError("<p>O número do documento pode ter no máximo 25 números! </p>");
				}
		}
		
		if(lancamento.getReversalFlag()){
			
			if(null == lancamento.getReversalNumber() || "".equals(lancamento.getReversalNumber().trim())){

				result.addError("<p>O valor de reversal number é obrigatório quando<br>" +
						" reversal flag estiver marcado. </p>");
				
			}else{
				
				if(!ValidationUtils.isNumeric(lancamento.getReversalNumber())){
					result.addError("<p>Reversal Number só pode conter números! </p>");
				}
				if(!ValidationUtils.hasMaximumLength(lancamento.getReversalNumber(), 25)){
					result.addError("<p>Reversal Number pode ter no máximo 25 números! </p>");
				}
				
			}
			
		}

		return result;
	}
	
	

	
	@Override
	public String getNumConta() {
		return lancamento.getNumConta();
	}

	@Override
	public void setNumConta(String numConta) {
		lancamento.setNumConta(numConta);
	}

	@Override
	public String getTransacao() {
		return lancamento.getTransacao();
	}

	@Override
	public void setTransacao(String transacao) {
		lancamento.setTransacao(transacao);
	}

	@Override
	public String getMotivo() {
		return lancamento.getMotivo();
	}

	@Override
	public void setMotivo(String motivo) {
		lancamento.setMotivo(motivo);
	}

	@Override
	public String getValor() {
		return lancamento.getValor();
	}

	@Override
	public void setValor(String valor) {
		lancamento.setValor(valor);
	}

	@Override
	public String getData() {
		return lancamento.getData();
	}

	@Override
	public void setData(String data) {
		lancamento.setData(data);
	}

	@Override
	public String getComentario() {
		return lancamento.getComentario();
	}

	@Override
	public void setComentario(String comentario) {
		lancamento.setComentario(comentario);
	}

	@Override
	public String getCategoria() {
		return lancamento.getCategoria();
	}

	@Override
	public void setCategoria(String categoria) {
		lancamento.setCategoria(categoria);
	}

	@Override
	public String getValorCheque24() {
		return lancamento.getValorCheque24();
	}

	@Override
	public void setValorCheque24(String valorCheque24) {
		lancamento.setValorCheque24(valorCheque24);
	}

	@Override
	public String getValorCheque48() {
		return lancamento.getValorCheque48();
	}

	@Override
	public void setValorCheque48(String valorCheque48) {
		lancamento.setValorCheque48(valorCheque48);
	}

	@Override
	public String getNumDocumento() {
		return lancamento.getNumDocumento();
	}

	@Override
	public void setNumDocumento(String numDocumento) {
		lancamento.setNumDocumento(numDocumento);
	}

	@Override
	public String getResposta() {
		return lancamento.getResposta();
	}

	@Override
	public void setResposta(String resposta) {
		lancamento.setResposta(resposta);
	}

	@Override
	public String getErrorList() {
		return lancamento.getErrorList();
	}

	@Override
	public void setErrorList(String errorList) {
		lancamento.setErrorList(errorList);
	}

	@Override
	public Boolean getReversalFlag() {
		return lancamento.getReversalFlag();
	}

	@Override
	public void setReversalFlag(Boolean reversalFlag) {
		lancamento.setReversalFlag(reversalFlag);
	}

	@Override
	public String getReversalNumber() {
		return lancamento.getReversalNumber();
	}

	@Override
	public void setReversalNumber(String ReversalNumber) {
		lancamento.setReversalNumber(ReversalNumber);
	}



}
