package br.com.bancooriginal.cyberbank.awt.validators;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

/**
 * Validador de numero inteiros.
 * @author filipe.sa
 *
 */
public class IntegerVerifier extends InputVerifier implements ActionListener{

	private int qtdDigitos;
	private boolean obrigatorio;
	
	/**
	 * Contrutor que recebe a quantidade de digitos inteiros possiveis
	 * para o campo de input, alem de receber um boleano que indica se o campo eh obrigatorio
	 * ou nao.
	 * @param qtdDigitos
	 * @param obrigatorio
	 */
	public IntegerVerifier(int qtdDigitos, boolean obrigatorio){
		this.qtdDigitos=qtdDigitos;
		this.obrigatorio=obrigatorio;
	}

	@Override
	public boolean verify(JComponent input) {
		
		JTextField textField = ((JTextField) input);
		
		if(obrigatorio && (null == textField.getText() || "".equals(textField.getText().trim()))){
			textField.setBackground(Color.RED);
			textField.setText("Campo obrigatório");
			return false;
		}
		
		if(!textField.getText().matches("\\d{1,"+qtdDigitos+"}+")){

			textField.setBackground(Color.RED);
			return false;
			
		}
		
		textField.setBackground(Color.WHITE);
		return true;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		
		JTextField source = (JTextField)e.getSource();
        shouldYieldFocus(source);
        source.selectAll();
		
	}

}
