package br.com.bancooriginal.cyberbank.awt.component;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JTextField;

/**
 * Listener usado para limpar um JtextField que tenha sido validado como campo obrigatorio.
 * A validacao deixa o campo vermelho com o texto campo obrigatorio dentro. Quando o usuario
 * pressiona qualquer tecla dentro do campo, este listener limpa o campo e deixa o fundo
 * branco novamente.
 * @author filipe.sa
 *
 */
public class CampoObrigatorioListener implements KeyListener{

	@Override
	public void keyPressed(KeyEvent k) {
		JTextField j = (JTextField) k.getSource();
		if(null != j.getText() && j.getText().equals("Campo obrigatório")){
			j.setText("");
		}	
		j.setBackground(Color.WHITE);
	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		
	}

	@Override
	public void keyTyped(KeyEvent arg0) {
		
	}

}
