/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.message.SimpleValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ValidationResult
implements Iterable<ValidationMessage>,
Serializable {
    public static final ValidationResult EMPTY = new ValidationResult(Collections.<ValidationMessage>emptyList(), false);
    private final List<ValidationMessage> messageList;
    private final boolean modifiable;

    public ValidationResult() {
        this(new ArrayList<ValidationMessage>(), true);
    }

    private ValidationResult(List<ValidationMessage> messageList, boolean modifiable) {
        this.messageList = messageList;
        this.modifiable = modifiable;
    }

    public static ValidationResult unmodifiableResult(ValidationResult validationResult) {
        return validationResult.modifiable ? new ValidationResult(new ArrayList<ValidationMessage>(validationResult.messageList), false) : validationResult;
    }

    public ValidationResult add(ValidationMessage validationMessage) {
        this.checkModifiable();
        Preconditions.checkNotNull(validationMessage, "The validation message must not be null.");
        Preconditions.checkArgument(validationMessage.severity() != Severity.OK, "You must not add a validation message with severity OK.");
        this.messageList.add(validationMessage);
        return this;
    }

    public ValidationResult addError(String text) {
        this.addError(text, null);
        return this;
    }

    public ValidationResult addError(String text, Object key) {
        this.checkModifiable();
        this.add(new SimpleValidationMessage(text, Severity.ERROR, key));
        return this;
    }

    public ValidationResult addWarning(String text) {
        this.addWarning(text, null);
        return this;
    }

    public ValidationResult addWarning(String text, Object key) {
        this.checkModifiable();
        this.add(new SimpleValidationMessage(text, Severity.WARNING, key));
        return this;
    }

    public ValidationResult addInfo(String text) {
        this.addInfo(text, null);
        return this;
    }

    public ValidationResult addInfo(String text, Object key) {
        this.checkModifiable();
        this.add(new SimpleValidationMessage(text, Severity.INFO, key));
        return this;
    }

    public void addAll(List<ValidationMessage> messages) {
        this.checkModifiable();
        Preconditions.checkNotNull(messages, "The messages list must not be null.");
        for (ValidationMessage message : messages) {
            Preconditions.checkArgument(message.severity() != Severity.OK, "You must not add a validation message with severity OK.");
        }
        this.messageList.addAll(messages);
    }

    public void addAllFrom(ValidationResult validationResult) {
        this.checkModifiable();
        Preconditions.checkNotNull(validationResult, "The validation result to add must not be null.");
        this.addAll(validationResult.messageList);
    }

    public boolean isEmpty() {
        return this.messageList.isEmpty();
    }

    public int size() {
        return this.messageList.size();
    }

    public boolean contains(ValidationMessage message) {
        return this.messageList.contains(message);
    }

    public ValidationMessage get(int index) {
        return this.messageList.get(index);
    }

    @Override
    public Iterator<ValidationMessage> iterator() {
        return this.messageList.iterator();
    }

    public ValidationResult subResult(int fromIndex, int toIndex) {
        List<ValidationMessage> messages = this.messageList.subList(fromIndex, toIndex);
        return new ValidationResult(messages, false);
    }

    public ValidationResult subResult(Object messageKey) {
        if (messageKey == null) {
            return EMPTY;
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : this.messageList) {
            if (!messageKey.equals(message.key())) continue;
            messages.add(message);
        }
        return new ValidationResult(messages, false);
    }

    public ValidationResult subResult(Object[] messageKeys) {
        if (messageKeys == null) {
            return EMPTY;
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : this.messageList) {
            Object messageKey = message.key();
            for (Object key : messageKeys) {
                if (!messageKey.equals(key)) continue;
                messages.add(message);
            }
        }
        return new ValidationResult(messages, false);
    }

    public Map<Object, ValidationResult> keyMap() {
        HashMap<Object, LinkedList<ValidationMessage>> messageMap = new HashMap<Object, LinkedList<ValidationMessage>>();
        for (ValidationMessage message : this.messageList) {
            Object key = message.key();
            LinkedList<ValidationMessage> associatedMessages = (LinkedList<ValidationMessage>)messageMap.get(key);
            if (associatedMessages == null) {
                associatedMessages = new LinkedList<ValidationMessage>();
                messageMap.put(key, associatedMessages);
            }
            associatedMessages.add(message);
        }
        HashMap resultMap = new HashMap(messageMap.size());
        for (Map.Entry entry : messageMap.entrySet()) {
            Object key = entry.getKey();
            List messages = (List)entry.getValue();
            resultMap.put(key, new ValidationResult(messages, false));
        }
        return Collections.unmodifiableMap(resultMap);
    }

    public Severity getSeverity() {
        return ValidationResult.getSeverity(this.messageList);
    }

    public boolean hasMessages() {
        return !this.isEmpty();
    }

    public boolean hasErrors() {
        return ValidationResult.hasSeverity(this.messageList, Severity.ERROR);
    }

    public boolean hasWarnings() {
        return ValidationResult.hasSeverity(this.messageList, Severity.WARNING);
    }

    public boolean hasInfos() {
        return ValidationResult.hasSeverity(this.messageList, Severity.INFO);
    }

    public List<ValidationMessage> getMessages() {
        return Collections.unmodifiableList(this.messageList);
    }

    public List<ValidationMessage> getErrors() {
        return ValidationResult.getMessagesWithSeverity(this.messageList, Severity.ERROR);
    }

    public List<ValidationMessage> getWarnings() {
        return ValidationResult.getMessagesWithSeverity(this.messageList, Severity.WARNING);
    }

    public List<ValidationMessage> getInfos() {
        return ValidationResult.getMessagesWithSeverity(this.messageList, Severity.INFO);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public String getMessagesText() {
        return ValidationResult.getMessagesText(this.messageList);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty ValidationResult";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.modifiable ? "Modifiable" : "Unmodifiable");
        builder.append(" ValidationResult:");
        for (ValidationMessage message : this.messageList) {
            builder.append("\n\t").append(message);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        return ((Object)this.messageList).equals(((ValidationResult)o).messageList);
    }

    public int hashCode() {
        return ((Object)this.messageList).hashCode();
    }

    private void checkModifiable() {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This validation result is unmodifiable.");
        }
    }

    private static Severity getSeverity(List<ValidationMessage> messages) {
        ValidationMessage message;
        Severity severity = Severity.OK;
        Iterator<ValidationMessage> i$ = messages.iterator();
        while (i$.hasNext() && (severity = Severity.max(severity, (message = i$.next()).severity())).ordinal() != 0) {
        }
        return severity;
    }

    private static boolean hasSeverity(List<ValidationMessage> messages, Severity severity) {
        for (ValidationMessage message : messages) {
            if (message.severity() != severity) continue;
            return true;
        }
        return false;
    }

    private static List<ValidationMessage> getMessagesWithSeverity(List<ValidationMessage> messages, Severity severity) {
        ArrayList<ValidationMessage> errorMessages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : messages) {
            if (message.severity() != severity) continue;
            errorMessages.add(message);
        }
        return Collections.unmodifiableList(errorMessages);
    }

    private static String getMessagesText(List<ValidationMessage> messages) {
        if (messages.isEmpty()) {
            return "OK";
        }
        StringBuilder builder = new StringBuilder();
        for (ValidationMessage message : messages) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(message.formattedText());
        }
        return builder.toString();
    }
}

