/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.ArquivoUtil;
import br.com.providernt.util.ZipUtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);
    private static int TAMANHO_BUFFER = 0x100000;

    public static File zip(File ... arquivosParaZipar) throws ZipUtilException {
        File arquivoDestino = null;
        try {
            arquivoDestino = File.createTempFile("temp", ".zip");
            ZipUtil.zipTo(arquivoDestino, arquivosParaZipar);
        }
        catch (ZipUtilException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("N\u00e3o foi poss\u00edvel criar arquivo tempor\u00e1rio.", e);
            throw new ZipUtilException("N\u00e3o foi poss\u00edvel criar arquivo tempor\u00e1rio.", e);
        }
        return arquivoDestino;
    }

    public static void zipTo(File arquivoDestino, File ... arquivosParaZipar) throws ZipUtilException {
        if (null == arquivoDestino) {
            throw new ZipUtilException("Arquivo Destino inv\u00e1lido.");
        }
        if (!ArquivoUtil.isZip(arquivoDestino.getAbsolutePath())) {
            throw new ZipUtilException("Arquivo inv\u00e1lido. Aceita apenas arquivo com extens\u00e3o .ZIP");
        }
        if (null == arquivosParaZipar) {
            throw new ZipUtilException("Arquivo para compactar inv\u00e1lido.");
        }
        if (arquivosParaZipar.length < 1) {
            throw new ZipUtilException("\u00c9 necess\u00e1rio pelo menos um arquivo para compactar.");
        }
        byte[] dados = new byte[TAMANHO_BUFFER];
        BufferedInputStream origem = null;
        FileInputStream streamDeEntrada = null;
        FileOutputStream destino = null;
        ZipOutputStream saida = null;
        ZipEntry entry = null;
        try {
            destino = new FileOutputStream(arquivoDestino);
            saida = new ZipOutputStream(new BufferedOutputStream(destino));
            for (File file : arquivosParaZipar) {
                int cont;
                streamDeEntrada = new FileInputStream(file);
                origem = new BufferedInputStream(streamDeEntrada, TAMANHO_BUFFER);
                entry = new ZipEntry(file.getName());
                saida.putNextEntry(entry);
                while ((cont = origem.read(dados, 0, TAMANHO_BUFFER)) != -1) {
                    saida.write(dados, 0, cont);
                }
            }
        }
        catch (Exception e) {
            logger.debug("N\u00e3o foi poss\u00edvel criar arquivo compactado.", e);
            throw new ZipUtilException("", e);
        }
        finally {
            dados = null;
            entry = null;
            streamDeEntrada = null;
            destino = null;
            try {
                if (null != origem) {
                    origem.close();
                    origem = null;
                }
                if (null != saida) {
                    saida.close();
                    saida = null;
                }
            }
            catch (IOException e) {
                logger.debug("N\u00e3o foi poss\u00edvel fechar recurso.", e);
            }
        }
    }

    public static List<File> unzip(File arquivoZIP) throws ZipUtilException {
        if (null == arquivoZIP) {
            throw new ZipUtilException("Arquivo inv\u00e1lido.");
        }
        File diretorioDestino = new File(arquivoZIP.getParent());
        return ZipUtil.unzip(arquivoZIP, diretorioDestino);
    }

    public static List<File> unzip(File arquivoZIP, File diretorioDestino) throws ZipUtilException {
        if (null == arquivoZIP) {
            throw new ZipUtilException("Arquivo inv\u00e1lido.");
        }
        if (!arquivoZIP.exists()) {
            throw new ZipUtilException("Arquivo inexistente.");
        }
        if (!ArquivoUtil.isZip(arquivoZIP.getAbsolutePath())) {
            throw new ZipUtilException("Arquivo inv\u00e1lido. Aceita apenas arquivo com extens\u00e3o .ZIP");
        }
        if (null == diretorioDestino) {
            throw new ZipUtilException("Diret\u00f3rio Destino inv\u00e1lido.");
        }
        if (!diretorioDestino.exists()) {
            throw new ZipUtilException("Diret\u00f3rio Destino inexistente.");
        }
        if (!diretorioDestino.isDirectory()) {
            throw new ZipUtilException("Destino n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido.");
        }
        ArrayList<File> arquivosDescompactados = new ArrayList<File>();
        byte[] buffer = new byte[1024];
        boolean erro = false;
        ZipInputStream zis = null;
        ZipEntry ze = null;
        FileOutputStream fos = null;
        File newFile = null;
        try {
            zis = new ZipInputStream(new FileInputStream(arquivoZIP));
            ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                logger.debug("File unzip: " + fileName);
                newFile = new File(diretorioDestino.getAbsolutePath() + File.separator + fileName);
                fos = new FileOutputStream(newFile);
                arquivosDescompactados.add(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
                logger.debug(arquivosDescompactados.size() + " arquivos descompactados.");
            }
        }
        catch (IllegalArgumentException e) {
            erro = true;
            logger.debug("Nome do Arquivo a ser descompactado n\u00e3o pode conter letras acentuadas.", e);
            throw new ZipUtilException("Nome do Arquivo a ser descompactado n\u00e3o pode conter letras acentuadas.", e);
        }
        catch (Exception e) {
            erro = true;
            logger.debug("N\u00e3o foi poss\u00edvel descompactar arquivos.", e);
            throw new ZipUtilException("N\u00e3o foi poss\u00edvel descompactar arquivos.", e);
        }
        finally {
            if (erro && null != arquivosDescompactados && !arquivosDescompactados.isEmpty()) {
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (Exception e1) {
                        logger.debug(e1.getMessage(), e1);
                    }
                }
                for (File f : arquivosDescompactados) {
                    f.delete();
                }
            }
            if (null != zis) {
                try {
                    zis.closeEntry();
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), e);
                }
                try {
                    zis.close();
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            zis = null;
            ze = null;
            fos = null;
            newFile = null;
        }
        return arquivosDescompactados;
    }
}

