/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.ImagemUtil;
import br.com.providernt.util.NekiUtilException;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NekiUtil
implements Serializable {
    private static final long serialVersionUID = -6484788391897722879L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagemUtil.class);
    public static final String PATH_TEMP_SO = System.getProperty("java.io.tmpdir") + File.separator;
    private static final String RB_ERROS = "errors";
    private static final String RB_MESSAGES = "messages";

    public static ResourceBundle getResourceBundleNekiUtil(String baseName) {
        Locale defaultLocale = Locale.getDefault();
        return ResourceBundle.getBundle(baseName, defaultLocale, NekiUtil.class.getClassLoader());
    }

    public static ResourceBundle getResourceBundle(String baseName) {
        Locale defaultLocale = Locale.getDefault();
        return ResourceBundle.getBundle(baseName, defaultLocale);
    }

    public static String getPath(File arquivo) {
        String nomeArquivo = "";
        if (null != arquivo) {
            if (arquivo.isDirectory()) {
                return arquivo.getAbsolutePath();
            }
            int lastIndex = arquivo.getAbsolutePath().lastIndexOf(File.separator);
            try {
                nomeArquivo = arquivo.getAbsolutePath().substring(0, lastIndex);
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.debug(e.getMessage(), e);
            }
        }
        return nomeArquivo;
    }

    public static Date formatarData(String data, String formato) throws NekiUtilException {
        if (null == data || "".equals(data)) {
            throw new NekiUtilException("Data n\u00e3o pode ser nulo ou vazio.");
        }
        if (null == formato || "".equals(formato)) {
            throw new NekiUtilException("Formato (mascara) n\u00e3o pode ser nulo ou vazio.");
        }
        SimpleDateFormat format = new SimpleDateFormat(formato);
        Date dataFormatada = null;
        try {
            dataFormatada = format.parse(data);
        }
        catch (ParseException e) {
            throw new NekiUtilException("N\u00e3o foi poss\u00edvel converter Data.", e);
        }
        return dataFormatada;
    }

    public static String formatarData(Calendar data, String formato) throws NekiUtilException {
        if (null == data) {
            throw new NekiUtilException("Data n\u00e3o pode ser nulo ou vazio.");
        }
        return NekiUtil.formatarData(data.getTime(), formato);
    }

    public static String formatarData(Date data, String formato) throws NekiUtilException {
        if (null == data) {
            throw new NekiUtilException("Data n\u00e3o pode ser nulo ou vazio.");
        }
        if (null == formato || "".equals(formato)) {
            throw new NekiUtilException("Formato (mascara) n\u00e3o pode ser nulo ou vazio.");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(formato);
            return format.format(data);
        }
        catch (Exception e) {
            throw new NekiUtilException("N\u00e3o foi poss\u00edvel converter Data.", e);
        }
    }

    public static String getMensagemErro(String chave) {
        return NekiUtil.getResourceBundle(RB_ERROS).getString(chave);
    }

    public static String getMensagemErro(String chave, Object ... argumentos) {
        String mensagem = NekiUtil.getMensagemErro(chave);
        return MessageFormat.format(mensagem, argumentos);
    }

    public static String getMensagem(String chave) {
        return NekiUtil.getResourceBundle(RB_MESSAGES).getString(chave);
    }

    public static String getMensagem(String chave, Object ... argumentos) {
        String mensagem = NekiUtil.getMensagem(chave);
        return MessageFormat.format(mensagem, argumentos);
    }

    private static String getMensagemErroNekiUtil(String chave) {
        return NekiUtil.getResourceBundleNekiUtil(RB_ERROS).getString(chave);
    }

    private static String getMensagemErroNekiUtil(String chave, Object ... argumentos) {
        String mensagem = NekiUtil.getMensagemErro(chave);
        return MessageFormat.format(mensagem, argumentos);
    }

    private static String getMensagemNekiUtil(String chave) {
        return NekiUtil.getResourceBundleNekiUtil(RB_MESSAGES).getString(chave);
    }

    private static String getMensagemNekiUtil(String chave, Object ... argumentos) {
        String mensagem = NekiUtil.getMensagem(chave);
        return MessageFormat.format(mensagem, argumentos);
    }

    public static double formatarMoeda(String valor) {
        valor = valor.replace(".", "");
        valor = valor.replace(",", ".");
        return Double.parseDouble(valor);
    }

    public static boolean isNumerico(String n) {
        if (null == n || "".equals(n)) {
            return false;
        }
        String regex = "[0-9]*";
        Pattern padrao = Pattern.compile(regex);
        Matcher pesquisa = padrao.matcher(n);
        return pesquisa.matches();
    }

    public static String getExtensao(String nomeArquivo) throws NekiUtilException {
        try {
            return nomeArquivo.substring(nomeArquivo.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            throw new NekiUtilException("N\u00e3o foi poss\u00edvel extrair extensao do arquivo.");
        }
    }
}

