/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.util;

import br.com.providernt.util.ImagemUtilException;
import br.com.providernt.util.NekiUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagemUtil.class);

    public static void resizeImage(File image, int width) throws ImagemUtilException {
        try {
            BufferedImage originalImage = ImageIO.read(image);
            double originalWidth = originalImage.getWidth();
            double originalHeight = originalImage.getHeight();
            double newHeight = originalHeight / (originalWidth / (double)width);
            LOGGER.debug((int)originalWidth + "x" + (int)originalHeight);
            LOGGER.debug(width + "x" + (int)newHeight);
            ImagemUtil.resizeImage(image, width, (int)newHeight);
        }
        catch (ImagemUtilException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImagemUtilException("N\u00e3o foi poss\u00edvel redimensionar imagem.", e);
        }
    }

    public static void resizeImage(File image, int width, int height) throws ImagemUtilException {
        try {
            BufferedImage originalImage = ImageIO.read(image);
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            BufferedImage resizeImageJpg = ImagemUtil.resizeImage(originalImage, type, width, height);
            ImageIO.write((RenderedImage)resizeImageJpg, NekiUtil.getExtensao(image.getName()), image);
        }
        catch (ImagemUtilException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImagemUtilException("N\u00e3o foi poss\u00edvel redimensionar imagem.", e);
        }
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int type, int width, int height) throws ImagemUtilException {
        try {
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(originalImage, 0, 0, width, height, null);
            g.dispose();
            return resizedImage;
        }
        catch (Exception e) {
            throw new ImagemUtilException("N\u00e3o foi poss\u00edvel redimensionar imagem.");
        }
    }
}

