/*
 * Decompiled with CFR 0.152.
 */
package br.com.providernt.io.excel;

import br.com.providernt.io.excel.XLSExport;
import br.com.providernt.io.excel.XLSRow;
import br.com.providernt.io.excel.XLSStyleALM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XLSData
extends XLSExport {
    private static final long serialVersionUID = -5852040213008828041L;
    public static final int MAX_LINHAS = 65535;
    public static final int MAX_LARGURA_COLUNA = 255;
    private String nomeArquivo;
    private int maiorLinha = 0;
    private final Map<Integer, XLSRow> linhas = new HashMap<Integer, XLSRow>();
    private final List<Short[]> mergeCelulas = new ArrayList<Short[]>();
    private final List<Integer[]> larguraColuna = new ArrayList<Integer[]>();

    public XLSData() {
    }

    public XLSData(String nomeArquivo) {
        this.setNomeArquivo(nomeArquivo);
    }

    public final XLSRow createRow(int posicaoLinha) {
        XLSRow linha = this.getRow(posicaoLinha);
        if (null == linha) {
            linha = new XLSRow(posicaoLinha);
            this.addRow(posicaoLinha, linha);
        }
        return linha;
    }

    public final void addRow(int posicaoLinha, XLSRow linha) {
        if (posicaoLinha < 0 || posicaoLinha > 65535) {
            throw new IllegalArgumentException("Linha (" + posicaoLinha + ") inv\u00e1lida. Permitida entre 0 e " + 65535 + ".");
        }
        if (null != linha) {
            this.linhas.put(posicaoLinha, linha);
            if (posicaoLinha > this.maiorLinha) {
                this.maiorLinha = posicaoLinha;
            }
        }
    }

    public final void addNextRow(XLSRow linha) {
        this.addRow(this.getNextIndex(), linha);
    }

    public final void addNextRow(int posicaoCelula, String conteudo) {
        XLSRow linha = new XLSRow(this.getNextIndex());
        linha.addCell(posicaoCelula, conteudo);
        this.addRow(linha.getIndexRow(), linha);
    }

    public final void addCell(int posicaoLinha, int posicaoCelula, String conteudo) {
        this.addCell(posicaoLinha, posicaoCelula, conteudo, null);
    }

    public final void addCell(int posicaoLinha, int posicaoCelula, String conteudo, XLSStyleALM estilo) {
        XLSRow linha = this.getRow(posicaoLinha);
        if (null == linha) {
            linha = new XLSRow(posicaoLinha);
        }
        linha.addCell(posicaoCelula, conteudo, estilo);
        this.addRow(posicaoLinha, linha);
    }

    public final void addNextCell(int posicaoLinha, String conteudo) {
        XLSRow linha = this.getRow(posicaoLinha);
        if (null == linha) {
            linha = new XLSRow(posicaoLinha);
        }
        linha.addNextCell(conteudo);
    }

    public final void addCells(int posicaoLinha, String ... conteudo) {
        this.addCells(posicaoLinha, (XLSStyleALM)null, conteudo);
    }

    public final void addCells(int posicaoLinha, XLSStyleALM estilo, String ... conteudo) {
        XLSRow linha = this.getRow(posicaoLinha);
        if (null == linha) {
            linha = new XLSRow(posicaoLinha);
        }
        linha.addCells(estilo, conteudo);
        this.addRow(posicaoLinha, linha);
    }

    public final int getNextIndex() {
        return this.maiorLinha + 1;
    }

    public final XLSRow getRow(int posicao) {
        return this.linhas.get(posicao);
    }

    @Override
    public final List<XLSRow> getRows() {
        ArrayList<XLSRow> l = new ArrayList<XLSRow>(this.linhas.values());
        Collections.sort(l);
        return l;
    }

    public final String getCell(int posicaoLinha, int posicaoCelula) {
        String celula = "";
        XLSRow linha = this.getRow(posicaoLinha);
        if (null != linha) {
            celula = linha.getCell(posicaoCelula);
        }
        return celula;
    }

    public final void addMergeCell(int linhaInicial, int linhaFinal, int celulaInicial, int celulaFinal) {
        Short[] mergeCell = new Short[]{(short)linhaInicial, (short)linhaFinal, (short)celulaInicial, (short)celulaFinal};
        this.getMergeCelulas().add(mergeCell);
    }

    public final void addLarguraColuna(int posicaoColuna, int larguraColuna) {
        XLSRow.validaPosicaoCelula(posicaoColuna);
        Integer[] lc = new Integer[]{posicaoColuna, larguraColuna};
        this.getLarguraColuna().add(lc);
    }

    private final void validaLarguraColuna(int larguraColuna) {
        if (larguraColuna < 0 || larguraColuna > 255) {
            throw new IllegalArgumentException("Largura (" + larguraColuna + ") inv\u00e1lida. Permitida entre 0 e " + 255 + ".");
        }
    }

    @Override
    public final String getNomeArquivo() {
        if (null == this.nomeArquivo || "".equals(this.nomeArquivo)) {
            this.nomeArquivo = "excel";
        }
        return this.nomeArquivo;
    }

    public final void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Override
    protected final List<Short[]> getMergeCelulas() {
        return this.mergeCelulas;
    }

    @Override
    protected final List<Integer[]> getLarguraColuna() {
        return this.larguraColuna;
    }
}

