/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class SessionIdGenerator {
    public static void main(String[] args) {
        System.out.println(SessionIdGenerator.generateSessionId());
    }

    public static String generateSessionId() {
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = new Integer(prng.nextInt()).toString();
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] result = sha.digest(randomNum.getBytes());
            return SessionIdGenerator.hexEncode(result);
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
            return null;
        }
    }

    private static String hexEncode(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int idx = 0; idx < aInput.length; ++idx) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString().toUpperCase().substring(0, 32);
    }
}

