/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.servico.client;

import br.com.bancooriginal.cyberbank.dto.Lancamento;
import br.com.bancooriginal.cyberbank.dto.Parametrizacao;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.client.BaseClient;
import br.com.bancooriginal.cyberbank.servico.client.MensagemHandler;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import br.com.bancooriginal.cyberbank.util.XMLUtil;
import java.awt.Color;
import java.io.File;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPFaultException;
import net.technisys.cmm.services.errors.v1.Errors;
import net.technisys.cmm.services.metadata.v1.Metadata;
import net.technisys.cmm.services.processaccountapply_external_movements_ws.v0.MovementFault;
import net.technisys.cmm.services.processaccountapply_external_movements_ws.v0.ProcessAccountApplyExternalMovementsWS;
import net.technisys.cmm.services.processaccountapply_external_movements_ws.v0.ProcessAccountApplyExternalMovementsWS_Service;
import net.technisys.cmm.services.processaccountapplyexternalmovementsws.rq.v1.MsgMovement;
import net.technisys.cmm.services.processaccountapplyexternalmovementsws.rq.v1.ProcessAccountApplyExternalMovementsWSRequest;
import net.technisys.cmm.services.processaccountapplyexternalmovementsws.rs.v1.Generic;
import net.technisys.cmm.services.processaccountapplyexternalmovementsws.rs.v1.ProcessAccountApplyExternalMovementsWSResponse;

public class CyberbankClient
extends BaseClient {
    String enderecoServico;

    public static void main(String ... args) {
        CyberbankClient client = new CyberbankClient();
        client.processar();
    }

    public void lancar(Lancamento lancamento) throws CyberBankException {
        try {
            Generic.Msg msg;
            Parametrizacao parametrizacao = XMLUtil.lerConfiguracoes(new File("parametrizacao.xml"));
            ProcessAccountApplyExternalMovementsWSRequest request = new ProcessAccountApplyExternalMovementsWSRequest();
            SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHMMsshhh");
            String data = sd.format(new Date());
            Metadata metadata = new Metadata();
            metadata.setServiceId("processAccountApply_External_Movements_WS");
            metadata.setServiceVersion("1.0");
            metadata.setServiceContext("ORG");
            metadata.setSessionId(parametrizacao.getSessionId());
            metadata.setUserId(parametrizacao.getUserId());
            metadata.setExecutingOperatorId(parametrizacao.getUserId());
            metadata.setSourceTime(data);
            metadata.setInstitutionId(parametrizacao.getInstitutionId());
            metadata.setBranchId(parametrizacao.getBranchId());
            metadata.setTerminalId(parametrizacao.getTerminalId());
            metadata.setParityCurrencyId(parametrizacao.getParityCurrencyId());
            metadata.setParityQuotationNemotecnic(parametrizacao.getParityQuotationTypeNemotecnic());
            metadata.setLocalCountryId(parametrizacao.getLocalCountryId());
            metadata.setLocalCurrencyId(parametrizacao.getLocalCurrencyId());
            metadata.setBankId(parametrizacao.getBankId());
            metadata.setSourceDate(data);
            metadata.setSourceTime(data);
            metadata.setMsgTypeId(parametrizacao.getMsgTypeId());
            metadata.setOriginBranchId(parametrizacao.getOriginBranchId());
            metadata.setDependencyId(parametrizacao.getDependencyId());
            metadata.setBusinessDate(lancamento.getDataParaMensagem());
            Metadata.ExecutingChannel executingChannel = new Metadata.ExecutingChannel();
            executingChannel.setMnemonic("8");
            metadata.setExecutingChannel(executingChannel);
            Metadata.CustomProperties custom = new Metadata.CustomProperties();
            custom.setServiceContext("ORG");
            metadata.setCustomProperties(custom);
            ArrayList<Handler> handlerChain = new ArrayList<Handler>();
            handlerChain.add(new MensagemHandler());
            Holder<Metadata> holder = new Holder<Metadata>();
            holder.value = metadata;
            MsgMovement mensagem = new MsgMovement();
            mensagem.setName("msgMovement");
            mensagem.setDataModel("product.financials");
            mensagem.setVersion("1.0");
            mensagem.setOperationId(lancamento.getNumConta());
            mensagem.setTxnCodeId(new BigInteger(lancamento.getTransacao()));
            mensagem.setReasonCodeId(new BigInteger(lancamento.getMotivo()));
            mensagem.setValuedDate(lancamento.getDataParaMensagem());
            mensagem.setAmount(new Double(lancamento.getValor().replace(",", ".")));
            if (null != lancamento.getValorCheque24() && !"".equals(lancamento.getValorCheque24().trim())) {
                mensagem.setChecks24Amount(new Double(lancamento.getValorCheque24().replace(",", ".")));
            } else {
                mensagem.setChecks24Amount(0.0);
            }
            if (null != lancamento.getValorCheque48() && !"".equals(lancamento.getValorCheque48().trim())) {
                mensagem.setChecks48Amount(new Double(lancamento.getValorCheque48().replace(",", ".")));
            } else {
                mensagem.setChecks48Amount(0.0);
            }
            if (null != lancamento.getNumDocumento() && !"".equals(lancamento.getNumDocumento().trim())) {
                mensagem.setDepositFormNumber(new BigInteger(lancamento.getNumDocumento()));
            }
            if (null != lancamento.getCategoria() && !"".equals(lancamento.getCategoria().trim())) {
                mensagem.setCategoryId(new BigInteger(lancamento.getCategoria()));
            }
            if (null != lancamento.getComentario()) {
                mensagem.setComments(lancamento.getComentario());
            }
            if (lancamento.getReversalFlag().booleanValue()) {
                mensagem.setReversalFlag(true);
                mensagem.setReversalNumber(new BigInteger(lancamento.getReversalNumber()));
            } else {
                mensagem.setReversalFlag(false);
            }
            request.setMsgMovement(mensagem);
            ProcessAccountApplyExternalMovementsWS_Service service = new ProcessAccountApplyExternalMovementsWS_Service();
            ProcessAccountApplyExternalMovementsWS port = service.getProcessAccountApplyExternalMovementsWSPort();
            BindingProvider bindingProvider = (BindingProvider)((Object)port);
            this.enderecoServico = parametrizacao.getEndereco();
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.enderecoServico);
            bindingProvider.getBinding().setHandlerChain(handlerChain);
            bindingProvider.getRequestContext().put("javax.xml.ws.client.connectionTimeout", 10000);
            bindingProvider.getRequestContext().put("javax.xml.ws.client.receiveTimeout", 10000);
            ProcessAccountApplyExternalMovementsWSResponse response = null;
            try {
                response = port.processAccountApplyExternalMovementsWS(request, holder);
            }
            catch (MovementFault e) {
                Errors erros = e.getFaultInfo();
                if (null != erros) {
                    List<Errors.Error> erroslist = erros.getError();
                    String errorList = "";
                    lancamento.setErrorList(errorList);
                    if (null != erroslist && !erroslist.isEmpty()) {
                        for (Errors.Error erro : erroslist) {
                            errorList = errorList + erro.getDetail() + "###";
                        }
                    }
                    lancamento.setErrorList(errorList);
                }
            }
            catch (SOAPFaultException se) {
                se.printStackTrace();
            }
            catch (RuntimeException r) {
                lancamento.setErrorList("N\u00e3o foi poss\u00edvel conectar o servi\u00e7o em: " + this.enderecoServico + "### Causa: " + r.getMessage());
            }
            catch (Exception e) {
                String erro = "";
                for (StackTraceElement st : e.getStackTrace()) {
                    erro = erro + st.toString() + "###";
                }
                JDialog d = new JDialog();
                d.setSize(600, 600);
                JLabel critica = new JLabel(erro);
                critica.setForeground(Color.RED);
                d.add(critica);
                d.setVisible(true);
                e.printStackTrace();
            }
            if (null != response && null != (msg = response.getGeneric().getMsg())) {
                lancamento.setResposta(msg.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CyberBankException(CBUtil.getMensagem("error.cyberbank.lancamento"), e);
        }
    }

    public void processar() {
    }

    @Override
    protected String getWsdl() {
        return null;
    }

    @Override
    protected String getNamespaceURI() {
        return null;
    }

    @Override
    protected String getLocalPart() {
        return null;
    }
}

