/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.validators;

import br.com.bancooriginal.cyberbank.dto.ILancamento;
import br.com.bancooriginal.cyberbank.dto.Lancamento;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.ValidationUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class LancamentoValidator
extends AbstractValueModel
implements Validator,
ILancamento {
    private static final long serialVersionUID = 1L;
    private ILancamento lancamento = new Lancamento();

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void setValue(Object arg0) {
    }

    public ILancamento getILancamento() {
        return this.lancamento;
    }

    public void setILancamento(ILancamento lancamento) {
        this.lancamento = lancamento;
    }

    public ValidationResult validate(Object arg0) {
        return new ValidationResult();
    }

    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (null == this.lancamento.getNumConta() || "".equals(this.lancamento.getNumConta().trim())) {
            result.addError("<p>O N\u00famero da Conta \u00e9 obrigat\u00f3rio! </p>");
        } else if (!ValidationUtils.hasMaximumLength(this.lancamento.getNumConta(), 25)) {
            result.addError("<p>O N\u00famero da Conta pode ter no m\u00e1ximo 25 caracteres! </p>");
        }
        if (null == this.lancamento.getTransacao() || "".equals(this.lancamento.getTransacao().trim())) {
            result.addError("<p>A Transa\u00e7\u00e3o \u00e9 obrigat\u00f3ria! </p>");
        } else {
            if (!ValidationUtils.isNumeric(this.lancamento.getTransacao())) {
                result.addError("<p>A Transa\u00e7\u00e3o s\u00f3 pode conter n\u00fameros! </p>");
            }
            if (!ValidationUtils.hasMaximumLength(this.lancamento.getTransacao(), 9)) {
                result.addError("<p>A Transa\u00e7\u00e3o pode ter no m\u00e1ximo 9 n\u00fameros! </p>");
            }
        }
        if (null == this.lancamento.getMotivo() || "".equals(this.lancamento.getMotivo().trim())) {
            result.addError("<p>O Motivo \u00e9 obrigat\u00f3rio! </p>");
        } else {
            if (!ValidationUtils.isNumeric(this.lancamento.getMotivo())) {
                result.addError("<p>O motivo s\u00f3 pode conter n\u00fameros! </p>");
            }
            if (!ValidationUtils.hasMaximumLength(this.lancamento.getMotivo(), 9)) {
                result.addError("<p>O motivo pode ter no m\u00e1ximo 9 n\u00fameros! </p>");
            }
        }
        if (null == this.lancamento.getValor() || "".equals(this.lancamento.getValor().trim())) {
            result.addError("<p>O Valor \u00e9 obrigat\u00f3rio! </p>");
        } else if (!this.lancamento.getValor().matches("^\\d{1,20}+(\\,\\d{0,5})?$")) {
            result.addError("<p>O valor deve ser num\u00e9rico com, no m\u00e1ximo,<br> 20 d\u00edgitos inteiros e 5 decimais. </p>");
        }
        if (null == this.lancamento.getData() || "".equals(this.lancamento.getData().replace("/", "").trim())) {
            result.addError("<p>A Data \u00e9 obrigat\u00f3ria! </p>");
        } else {
            SimpleDateFormat sd = new SimpleDateFormat("dd/MM/yyyy");
            try {
                sd.setLenient(false);
                sd.parse(this.lancamento.getData());
            }
            catch (ParseException e) {
                result.addError("<p>Data inv\u00e1lida! Deve seguir o padr\u00e3o dd/mm/aaaa. </p>");
            }
        }
        if (null != this.lancamento.getCategoria()) {
            if (!ValidationUtils.isNumeric(this.lancamento.getCategoria())) {
                result.addError("<p>Categoria s\u00f3 pode conter n\u00fameros! </p>");
            }
            if (!ValidationUtils.hasMaximumLength(this.lancamento.getReversalNumber(), 25)) {
                result.addError("<p>Categoria pode ter no m\u00e1ximo 9 n\u00fameros! </p>");
            }
        }
        if (null != this.lancamento.getValorCheque24() && !"".equals(this.lancamento.getValorCheque24().trim()) && !this.lancamento.getValorCheque24().matches("^\\d{1,20}+(\\,\\d{0,5})?$")) {
            result.addError("<p>O valor Cheque 24 horas deve ser num\u00e9rico com, no m\u00e1ximo,<br> 20 d\u00edgitos inteiros e 5 decimais. </p>");
        }
        if (null != this.lancamento.getValorCheque48() && !"".equals(this.lancamento.getValorCheque48().trim()) && !this.lancamento.getValorCheque48().matches("^\\d{1,20}+(\\,\\d{0,5})?$")) {
            result.addError("<p>O valor Cheque 48 horas deve ser num\u00e9rico com, no m\u00e1ximo,<br> 20 d\u00edgitos inteiros e 5 decimais. </p>");
        }
        if (this.lancamento.getReversalFlag().booleanValue()) {
            if (null != this.lancamento.getReversalNumber() && !"".equals(this.lancamento.getReversalNumber())) {
                result.addError("<p>O valor de reversal number \u00e9 obrigat\u00f3rio quando<br> reversal flag estiver marcado. </p>");
            } else {
                if (!ValidationUtils.isNumeric(this.lancamento.getReversalNumber())) {
                    result.addError("<p>Reversal Number s\u00f3 pode conter n\u00fameros! </p>");
                }
                if (!ValidationUtils.hasMaximumLength(this.lancamento.getReversalNumber(), 25)) {
                    result.addError("<p>Reversal Number pode ter no m\u00e1ximo 25 n\u00fameros! </p>");
                }
            }
        }
        if (null == this.lancamento.getNumDocumento() || "".equals(this.lancamento.getNumDocumento().trim())) {
            result.addError("<p>O n\u00famero do documento \u00e9 obrigat\u00f3rio! </p>");
            if (!ValidationUtils.isNumeric(this.lancamento.getNumDocumento())) {
                result.addError("<p>O n\u00famero do documento s\u00f3 pode conter n\u00fameros! </p>");
            }
            if (!ValidationUtils.hasMaximumLength(this.lancamento.getReversalNumber(), 25)) {
                result.addError("<p>O n\u00famero do documento pode ter no m\u00e1ximo 25 n\u00fameros! </p>");
            }
        }
        return result;
    }

    @Override
    public String getNumConta() {
        return this.lancamento.getNumConta();
    }

    @Override
    public void setNumConta(String numConta) {
        this.lancamento.setNumConta(numConta);
    }

    @Override
    public String getTransacao() {
        return this.lancamento.getTransacao();
    }

    @Override
    public void setTransacao(String transacao) {
        this.lancamento.setTransacao(transacao);
    }

    @Override
    public String getMotivo() {
        return this.lancamento.getMotivo();
    }

    @Override
    public void setMotivo(String motivo) {
        this.lancamento.setMotivo(motivo);
    }

    @Override
    public String getValor() {
        return this.lancamento.getValor();
    }

    @Override
    public void setValor(String valor) {
        this.lancamento.setValor(valor);
    }

    @Override
    public String getData() {
        return this.lancamento.getData();
    }

    @Override
    public void setData(String data) {
        this.lancamento.setData(data);
    }

    @Override
    public String getComentario() {
        return this.lancamento.getComentario();
    }

    @Override
    public void setComentario(String comentario) {
        this.lancamento.setComentario(comentario);
    }

    @Override
    public String getCategoria() {
        return this.lancamento.getCategoria();
    }

    @Override
    public void setCategoria(String categoria) {
        this.lancamento.setCategoria(categoria);
    }

    @Override
    public String getValorCheque24() {
        return this.lancamento.getValorCheque24();
    }

    @Override
    public void setValorCheque24(String valorCheque24) {
        this.lancamento.setValorCheque24(valorCheque24);
    }

    @Override
    public String getValorCheque48() {
        return this.lancamento.getValorCheque48();
    }

    @Override
    public void setValorCheque48(String valorCheque48) {
        this.lancamento.setValorCheque48(valorCheque48);
    }

    @Override
    public String getNumDocumento() {
        return this.lancamento.getNumDocumento();
    }

    @Override
    public void setNumDocumento(String numDocumento) {
        this.lancamento.setNumDocumento(numDocumento);
    }

    @Override
    public String getResposta() {
        return this.lancamento.getResposta();
    }

    @Override
    public void setResposta(String resposta) {
        this.lancamento.setResposta(resposta);
    }

    @Override
    public String getErrorList() {
        return this.lancamento.getErrorList();
    }

    @Override
    public void setErrorList(String errorList) {
        this.lancamento.setErrorList(errorList);
    }

    @Override
    public Boolean getReversalFlag() {
        return this.lancamento.getReversalFlag();
    }

    @Override
    public void setReversalFlag(Boolean reversalFlag) {
        this.lancamento.setReversalFlag(reversalFlag);
    }

    @Override
    public String getReversalNumber() {
        return this.lancamento.getReversalNumber();
    }

    @Override
    public void setReversalNumber(String ReversalNumber) {
        this.lancamento.setReversalNumber(ReversalNumber);
    }
}

