/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.validators;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class IntegerVerifier
extends InputVerifier
implements ActionListener {
    private int qtdDigitos;
    private boolean obrigatorio;

    public IntegerVerifier(int qtdDigitos, boolean obrigatorio) {
        this.qtdDigitos = qtdDigitos;
        this.obrigatorio = obrigatorio;
    }

    @Override
    public boolean verify(JComponent input) {
        JTextField textField = (JTextField)input;
        if (this.obrigatorio && (null == textField.getText() || "".equals(textField.getText().trim()))) {
            textField.setBackground(Color.RED);
            textField.setText("Campo obrigat\u00f3rio");
            return false;
        }
        if (!textField.getText().matches("\\d{1," + this.qtdDigitos + "}+")) {
            textField.setBackground(Color.RED);
            return false;
        }
        textField.setBackground(Color.WHITE);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextField source = (JTextField)e.getSource();
        this.shouldYieldFocus(source);
        source.selectAll();
    }
}

