/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.janela.page;

import br.com.bancooriginal.cyberbank.awt.component.PainelImagem;
import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.awt.janela.page.IPage;
import br.com.bancooriginal.cyberbank.awt.janela.page.Lancamento2Page;
import br.com.bancooriginal.cyberbank.awt.janela.page.ParametrizacaoPage;
import br.com.bancooriginal.cyberbank.enums.Ambiente;
import br.com.bancooriginal.cyberbank.enums.ComboControllerType;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.client.SecurityClient;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import br.com.bancooriginal.cyberbank.util.XMLUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PrincipalPage
implements IPage {
    private final JPanel panel = new JPanel();

    public PrincipalPage() {
        this.panel.setLayout(new BorderLayout());
        JLabel logo = new JLabel(CBUtil.getMensagem("messages.cyberbank.title.page.principal"));
        logo.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 20));
        logo.setFont(new Font("Arial", 0, 18));
        logo.setForeground(Color.WHITE);
        JLabel selectAmbienteLabel = new JLabel("Selecione o ambiente:  ");
        JLabel selectOperationLabel = new JLabel(CBUtil.getMensagem("messages.cyberbank.label.select.operation") + "  ");
        JComboBox<ComboControllerType> operationsCombo = new JComboBox<ComboControllerType>();
        operationsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemSelected) {
                if (null != itemSelected && itemSelected.getStateChange() == 1) {
                    ComboControllerType item = (ComboControllerType)((Object)itemSelected.getItem());
                    IPage page = null;
                    if (ComboControllerType.PARAMETRIZACAO.equals((Object)item)) {
                        page = new ParametrizacaoPage();
                    } else if (ComboControllerType.LANCAMENTO_CC.equals((Object)item)) {
                        page = new Lancamento2Page();
                    } else if (ComboControllerType.GERAR_SESSIONID.equals((Object)item)) {
                        SecurityClient securityClient = new SecurityClient();
                        try {
                            securityClient.autenticar();
                        }
                        catch (CyberBankException e) {
                            JOptionPane.showMessageDialog(null, e.getMessage(), "Status Login", 1);
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Sess\u00e3o criada com sucesso!", "Status Login", 1);
                    }
                    Janela.getInstance().show(page);
                }
            }
        });
        operationsCombo.addItem(ComboControllerType.SELECT);
        operationsCombo.addItem(ComboControllerType.PARAMETRIZACAO);
        operationsCombo.addItem(ComboControllerType.LANCAMENTO_CC);
        operationsCombo.addItem(ComboControllerType.GERAR_SESSIONID);
        JComboBox<Ambiente> ambienteCombo = new JComboBox<Ambiente>();
        ambienteCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemSelected) {
                Ambiente ambienteSelecionado = (Ambiente)((Object)itemSelected.getItem());
                XMLUtil.escreverAtributoParametrizacao("ambiente", ambienteSelecionado.name());
            }
        });
        Ambiente ambienteAtual = Ambiente.valueOf(XMLUtil.recuperarAtributoParametrizacao("ambiente"));
        ambienteCombo.addItem(ambienteAtual);
        if (ambienteAtual != Ambiente.DES) {
            ambienteCombo.addItem(Ambiente.DES);
        }
        if (ambienteAtual != Ambiente.ACE) {
            ambienteCombo.addItem(Ambiente.ACE);
        }
        if (ambienteAtual != Ambiente.HOM) {
            ambienteCombo.addItem(Ambiente.HOM);
        }
        PainelImagem painelTopo = new PainelImagem(CBUtil.createImage("images/barra.png"));
        PainelImagem painelLogo = new PainelImagem(CBUtil.createImage("images/logooriginal.png"));
        Dimension dim = new Dimension(400, 200);
        painelLogo.setPreferredSize(dim);
        FormLayout formLayout = new FormLayout("right:pref:grow, left:pref:grow", "40px, 40px, 40px, 40px, 210px, 90px, 40px");
        JPanel painelCentral = new JPanel(formLayout);
        this.panel.add((Component)painelTopo, "North");
        this.panel.add((Component)painelCentral, "Center");
        painelTopo.add(logo);
        CellConstraints cc = new CellConstraints();
        painelCentral.add((Component)selectAmbienteLabel, cc.xy(1, 2));
        painelCentral.add(ambienteCombo, cc.xy(2, 2));
        painelCentral.add((Component)selectOperationLabel, cc.xy(1, 3));
        painelCentral.add(operationsCombo, cc.xy(2, 3));
        painelCentral.add((Component)painelLogo, cc.xywh(1, 6, 2, 1, "left, bottom"));
        JLabel creditos = new JLabel("    Cliente Conta Corrente 1.0 - 13/08/2014");
        painelCentral.add((Component)creditos, cc.xywh(1, 7, 2, 1, "left, bottom"));
    }

    @Override
    public void exibir() {
        this.montar();
    }

    @Override
    public Container getContentPane() {
        return this.panel;
    }

    private void montar() {
    }

    class ComboItem {
        private final ComboControllerType id;
        private final String text;

        public ComboItem(ComboControllerType id, String text) {
            this.id = id;
            this.text = text;
        }

        public ComboControllerType getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }
    }
}

