/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.janela.page;

import br.com.bancooriginal.cyberbank.awt.component.InstrucoesParametrizacaoModel;
import br.com.bancooriginal.cyberbank.awt.component.MultilineTableCell;
import br.com.bancooriginal.cyberbank.awt.component.PainelImagem;
import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.awt.janela.page.IPage;
import br.com.bancooriginal.cyberbank.awt.janela.page.PrincipalPage;
import br.com.bancooriginal.cyberbank.awt.validators.IntegerVerifier;
import br.com.bancooriginal.cyberbank.awt.validators.StringVerifier;
import br.com.bancooriginal.cyberbank.controller.ParametrizacaoController;
import br.com.bancooriginal.cyberbank.dto.Parametrizacao;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.soap.SubmitService;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import br.com.bancooriginal.cyberbank.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class ParametrizacaoPage
implements IPage {
    private final JPanel panel = new JPanel();
    private JPanel painelCentral;
    private final int alinhamentoLabel = 4;
    private final EmptyBorder border = new EmptyBorder(10, 10, 10, 10);
    private final JTextField userId = new JTextField();
    private final JTextField sessionId = new JTextField();
    private final JTextField institutionId = new JTextField();
    private final JTextField branchId = new JTextField();
    private final JTextField channelId = new JTextField();
    private final JTextField terminalId = new JTextField();
    private final JTextField parityCurrencyCodeId = new JTextField();
    private final JTextField parityQuotationTypeNemotecnic = new JTextField();
    private final JTextField localCountryId = new JTextField();
    private final JTextField localCurrencyCodeId = new JTextField();
    private final JTextField bankId = new JTextField();
    private final JTextField msgTypeId = new JTextField();
    private final JTextField originBranchId = new JTextField();
    private final JTextField dependencyId = new JTextField();
    Parametrizacao parametrizacao;

    @Override
    public void exibir() {
        this.montar();
    }

    @Override
    public Container getContentPane() {
        return this.panel;
    }

    private void montar() {
        this.panel.setLayout(new BorderLayout());
        JLabel logo = new JLabel(CBUtil.getMensagem("messages.cyberbank.title.page.parametrizacao"));
        logo.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 20));
        logo.setFont(new Font("Arial", 0, 18));
        logo.setForeground(Color.WHITE);
        this.parametrizacao = XMLUtil.lerConfiguracoes(new File("parametrizacao.xml"));
        if (null != this.parametrizacao) {
            this.userId.setText(this.parametrizacao.getUserId());
            this.sessionId.setText(this.parametrizacao.getSessionId());
            this.institutionId.setText(this.parametrizacao.getInstitutionId());
            this.branchId.setText(this.parametrizacao.getBranchId());
            this.parityCurrencyCodeId.setText(this.parametrizacao.getParityCurrencyId());
            this.parityQuotationTypeNemotecnic.setText(this.parametrizacao.getParityQuotationTypeNemotecnic());
            this.localCountryId.setText(this.parametrizacao.getLocalCountryId());
            this.localCurrencyCodeId.setText(this.parametrizacao.getLocalCurrencyId());
            this.bankId.setText(this.parametrizacao.getBankId());
            this.originBranchId.setText(this.parametrizacao.getOriginBranchId());
            this.dependencyId.setText(this.parametrizacao.getDependencyId());
            this.channelId.setText(this.parametrizacao.getChannelId());
            this.terminalId.setText(this.parametrizacao.getTerminalId());
            this.msgTypeId.setText(this.parametrizacao.getMsgTypeId());
        } else {
            this.channelId.setText("20");
            this.terminalId.setText("ws");
            this.msgTypeId.setText("200");
            this.institutionId.setText("1111");
            this.branchId.setText("1");
            this.parityCurrencyCodeId.setText("212");
            this.parityQuotationTypeNemotecnic.setText("0");
            this.localCountryId.setText("55");
            this.localCurrencyCodeId.setText("1");
            this.bankId.setText("212");
            this.userId.setText("Simulador");
            this.originBranchId.setText("1");
            this.dependencyId.setText("1");
        }
        this.userId.setInputVerifier(new StringVerifier(25, true, null));
        this.userId.addActionListener(new StringVerifier(25, true, null));
        this.sessionId.setInputVerifier(new StringVerifier(40, true, null));
        this.sessionId.addActionListener(new StringVerifier(40, true, null));
        this.institutionId.setInputVerifier(new IntegerVerifier(4, true));
        this.institutionId.addActionListener(new IntegerVerifier(4, true));
        this.branchId.setInputVerifier(new IntegerVerifier(9, true));
        this.branchId.addActionListener(new IntegerVerifier(9, true));
        this.parityCurrencyCodeId.setInputVerifier(new IntegerVerifier(4, true));
        this.parityCurrencyCodeId.addActionListener(new IntegerVerifier(4, true));
        this.parityQuotationTypeNemotecnic.setInputVerifier(new IntegerVerifier(9, true));
        this.parityQuotationTypeNemotecnic.addActionListener(new IntegerVerifier(9, true));
        this.localCountryId.setInputVerifier(new IntegerVerifier(9, true));
        this.localCountryId.addActionListener(new IntegerVerifier(9, true));
        this.localCurrencyCodeId.setInputVerifier(new IntegerVerifier(4, true));
        this.localCurrencyCodeId.addActionListener(new IntegerVerifier(4, true));
        this.bankId.setInputVerifier(new IntegerVerifier(9, true));
        this.bankId.addActionListener(new IntegerVerifier(9, true));
        this.originBranchId.setInputVerifier(new IntegerVerifier(9, true));
        this.originBranchId.addActionListener(new IntegerVerifier(9, true));
        this.dependencyId.setInputVerifier(new IntegerVerifier(9, true));
        this.dependencyId.addActionListener(new IntegerVerifier(9, true));
        this.channelId.setEditable(false);
        this.terminalId.setEditable(false);
        this.msgTypeId.setEditable(false);
        JLabel userIdLabel = this.createLabel("userId");
        JLabel sessionIdLabel = this.createLabel("sessionId");
        JLabel institutionIdLabel = this.createLabel("institutionId");
        JLabel branchIdLabel = this.createLabel("branchId");
        JLabel channelIdLabel = this.createLabel("channelId");
        JLabel terminalIdLabel = this.createLabel("terminalId");
        JLabel parityCurrencyCodeIdLabel = this.createLabel("parityCurrencyCodeId");
        JLabel parityQuotationTypeNemotecnicLabel = this.createLabel("parityQuotationTypeNemotecnic");
        JLabel localCountryIdLabel = this.createLabel("localCountryId");
        JLabel localCurrencyCodeIdLabel = this.createLabel("localCurrencyCodeId");
        JLabel bankIdLabel = this.createLabel("bankId");
        JLabel msgTypeIdLabel = this.createLabel("msgTypeId");
        JLabel originBranchIdLabel = this.createLabel("originBranchId");
        JLabel dependencyIdLabel = this.createLabel("dependencyId");
        JButton btProcessar = this.createBtProcessar();
        JButton btInstrucoes = this.createBtInstrucoes();
        JButton btCancelar = this.createBtCancelar();
        PainelImagem painelTopo = new PainelImagem(CBUtil.createImage("images/barra.png"));
        this.painelCentral = new JPanel(new GridLayout(16, 2));
        this.painelCentral.setBorder(BorderFactory.createEmptyBorder(30, 20, 30, 20));
        JPanel painelBotao = new JPanel(new GridLayout(1, 3));
        painelBotao.setBorder(BorderFactory.createEmptyBorder(0, 20, 30, 20));
        painelBotao.add(btProcessar);
        painelBotao.add(btInstrucoes);
        painelBotao.add(btCancelar);
        this.panel.add((Component)painelTopo, "North");
        this.panel.add((Component)this.painelCentral, "Center");
        this.panel.add((Component)painelBotao, "South");
        painelTopo.add(logo);
        this.painelCentral.add(userIdLabel);
        this.painelCentral.add(this.userId);
        this.painelCentral.add(sessionIdLabel);
        this.painelCentral.add(this.sessionId);
        this.painelCentral.add(institutionIdLabel);
        this.painelCentral.add(this.institutionId);
        this.painelCentral.add(branchIdLabel);
        this.painelCentral.add(this.branchId);
        this.painelCentral.add(channelIdLabel);
        this.painelCentral.add(this.channelId);
        this.painelCentral.add(terminalIdLabel);
        this.painelCentral.add(this.terminalId);
        this.painelCentral.add(parityCurrencyCodeIdLabel);
        this.painelCentral.add(this.parityCurrencyCodeId);
        this.painelCentral.add(parityQuotationTypeNemotecnicLabel);
        this.painelCentral.add(this.parityQuotationTypeNemotecnic);
        this.painelCentral.add(localCountryIdLabel);
        this.painelCentral.add(this.localCountryId);
        this.painelCentral.add(localCurrencyCodeIdLabel);
        this.painelCentral.add(this.localCurrencyCodeId);
        this.painelCentral.add(bankIdLabel);
        this.painelCentral.add(this.bankId);
        this.painelCentral.add(msgTypeIdLabel);
        this.painelCentral.add(this.msgTypeId);
        this.painelCentral.add(originBranchIdLabel);
        this.painelCentral.add(this.originBranchId);
        this.painelCentral.add(dependencyIdLabel);
        this.painelCentral.add(this.dependencyId);
    }

    private Parametrizacao getParametrizacao() {
        Parametrizacao p = new Parametrizacao();
        p.setUserId(this.userId.getText());
        p.setSessionId(this.sessionId.getText());
        p.setInstitutionId(this.institutionId.getText());
        p.setBranchId(this.branchId.getText());
        p.setChannelId(this.channelId.getText());
        p.setTerminalId(this.terminalId.getText());
        p.setParityCurrencyId(this.parityCurrencyCodeId.getText());
        p.setParityQuotationTypeNemotecnic(this.parityQuotationTypeNemotecnic.getText());
        p.setLocalCountryId(this.localCountryId.getText());
        p.setLocalCurrencyId(this.localCurrencyCodeId.getText());
        p.setBankId(this.bankId.getText());
        p.setMsgTypeId(this.msgTypeId.getText());
        p.setOriginBranchId(this.originBranchId.getText());
        p.setDependencyId(this.dependencyId.getText());
        p.setAmbiente(this.parametrizacao.getAmbiente());
        p.setEnderecoAmbienteAce(this.parametrizacao.getEnderecoAmbienteAce());
        p.setEnderecoAmbienteDes(this.parametrizacao.getEnderecoAmbienteDes());
        p.setEnderecoAmbienteHom(this.parametrizacao.getEnderecoAmbienteHom());
        return p;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(CBUtil.getMensagem("messages.cyberbank.label.param." + text), 4);
        label.setBorder(this.border);
        return label;
    }

    private JButton createBotao(String text) {
        JButton botao = new JButton(text);
        botao.setToolTipText(text);
        botao.setBorder(new EmptyBorder(6, 5, 6, 5));
        botao.add(Box.createRigidArea(new Dimension(100, 20)));
        return botao;
    }

    private JButton createBtProcessar() {
        JButton botao = this.createBotao(CBUtil.getMensagem("messages.cyberbank.button.process"));
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParametrizacaoController controller = new ParametrizacaoController(ParametrizacaoPage.this.getParametrizacao());
                try {
                    if (!ParametrizacaoPage.this.validarFormulario()) {
                        return;
                    }
                    SubmitService.processar(controller);
                }
                catch (CyberBankException e1) {
                    System.out.println(e1.getMessage());
                    e1.printStackTrace();
                    return;
                }
                JOptionPane.showMessageDialog(null, "Altera\u00e7\u00e3o realizada com sucesso!", "Parametriza\u00e7\u00e3o", 1);
            }
        });
        return botao;
    }

    private JButton createBtCancelar() {
        JButton botao = this.createBotao("voltar");
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrincipalPage principal = new PrincipalPage();
                Janela.getInstance().show(principal);
            }
        });
        return botao;
    }

    private boolean validarFormulario() {
        boolean valido = true;
        for (Component c : this.painelCentral.getComponents()) {
            InputVerifier verifier;
            JComponent j = (JComponent)c;
            if (!(j instanceof JTextField) || null == (verifier = j.getInputVerifier())) continue;
            if (valido) {
                valido = j.getInputVerifier().verify(j);
                continue;
            }
            j.getInputVerifier().verify(j);
        }
        return valido;
    }

    private JButton createBtInstrucoes() {
        JButton botao = this.createBotao(CBUtil.getMensagem("messages.cyberbank.button.instructions"));
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame framepop = new JFrame();
                framepop.setLayout(new BorderLayout());
                Dimension dim = new Dimension(680, 600);
                framepop.setSize(dim);
                framepop.setMinimumSize(dim);
                framepop.setMaximumSize(dim);
                framepop.setLocationRelativeTo(null);
                framepop.setResizable(false);
                framepop.setVisible(true);
                JPanel panelpop = new JPanel();
                panelpop.setLayout(new BorderLayout());
                panelpop.setVisible(true);
                panelpop.setBackground(Color.YELLOW);
                JLabel logoPop = new JLabel(CBUtil.getMensagem("Instru\u00e7\u00f5es"));
                logoPop.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 20));
                logoPop.setFont(new Font("Arial", 0, 18));
                logoPop.setForeground(Color.WHITE);
                PainelImagem painelTopoPop = new PainelImagem(CBUtil.createImage("images/barra.png"));
                painelTopoPop.setLocation(0, 0);
                painelTopoPop.add(logoPop);
                JPanel painelCentralPop = new JPanel();
                painelCentralPop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                JTable table = new JTable(new InstrucoesParametrizacaoModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public TableCellRenderer getCellRenderer(int row, int column) {
                        MultilineTableCell wordWrapRenderer = new MultilineTableCell();
                        if (row <= 8 && column == 2) {
                            return wordWrapRenderer;
                        }
                        if (row > 8 && row < 13 && column == 3) {
                            return wordWrapRenderer;
                        }
                        if (row > 13 && column == 2) {
                            return wordWrapRenderer;
                        }
                        return super.getCellRenderer(row, column);
                    }
                };
                Dimension dim2 = new Dimension(600, 500);
                JScrollPane scrollPane = new JScrollPane(table);
                table.setFillsViewportHeight(true);
                scrollPane.setPreferredSize(dim2);
                painelCentralPop.add(scrollPane);
                JPanel painelBotaoPop = new JPanel(new GridLayout(1, 3));
                painelBotaoPop.setBorder(BorderFactory.createEmptyBorder(0, 20, 30, 20));
                panelpop.add((Component)painelTopoPop, "North");
                panelpop.add((Component)painelCentralPop, "Center");
                framepop.add(panelpop);
                JButton botao = new JButton("fechar");
                botao.setToolTipText("fechar");
                botao.setBorder(new EmptyBorder(6, 5, 6, 5));
                botao.add(Box.createRigidArea(new Dimension(100, 20)));
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                Popup popup = popupFactory.getPopup(framepop, botao, 0, 0);
                popup.show();
            }
        });
        return botao;
    }
}

