/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.janela.page;

import br.com.bancooriginal.cyberbank.awt.component.PainelImagem;
import br.com.bancooriginal.cyberbank.awt.janela.Janela;
import br.com.bancooriginal.cyberbank.awt.janela.page.IPage;
import br.com.bancooriginal.cyberbank.awt.janela.page.PrincipalPage;
import br.com.bancooriginal.cyberbank.awt.janela.page.ResultadoPage;
import br.com.bancooriginal.cyberbank.awt.validators.LancamentoValidator;
import br.com.bancooriginal.cyberbank.controller.LancamentoController;
import br.com.bancooriginal.cyberbank.dto.Lancamento;
import br.com.bancooriginal.cyberbank.exception.CyberBankException;
import br.com.bancooriginal.cyberbank.servico.soap.SubmitService;
import br.com.bancooriginal.cyberbank.util.CBUtil;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.MaskFormatter;

public class Lancamento2Page
implements IPage {
    private final JPanel page = new JPanel(new BorderLayout());
    private final EmptyBorder border = new EmptyBorder(10, 10, 10, 10);
    private final int alinhamentoLabel = 4;
    private final ValidationResultModel validationResultModel = new DefaultValidationResultModel();
    private PresentationModel mPresentationModel = new PresentationModel(new LancamentoValidator());
    private JLabel mMessageLabel = ValidationResultViewFactory.createReportIconAndTextLabel(this.validationResultModel);
    private JTextField numConta = new JTextField(20);
    private JTextField transacao = new JTextField(20);
    private JTextField motivo = new JTextField(20);
    private JTextField valor;
    private JTextField data;
    private JTextField comentario = new JTextField(20);
    private JTextField categoria = new JTextField(20);
    private JTextField valorCheque24;
    private JTextField valorCheque48;
    private JTextField numDocumento = new JTextField(20);
    private JCheckBox reversalFlag = new JCheckBox();
    private JTextField reversalNumber = new JTextField(20);
    private NumberFormat amountFormat;
    private NumberFormat percentFormat;
    private NumberFormat paymentFormat;
    private JLabel criticas;
    double valorValue = 0.0;

    public Lancamento2Page(Lancamento lancamento) {
        LancamentoValidator validator = (LancamentoValidator)this.mPresentationModel.getBean();
        validator.setILancamento(lancamento);
        this.montar();
    }

    public Lancamento2Page() {
        this.montar();
    }

    public JLabel createLabel(String text, int prefWidth, int prefHeight) {
        JLabel label = this.createLabel(text);
        label.setPreferredSize(new Dimension(prefWidth, prefHeight));
        return label;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(CBUtil.getMensagem("messages.cyberbank.label.lancamento." + text), 4);
        label.setBorder(this.border);
        return label;
    }

    @Override
    public void exibir() {
        this.montar();
    }

    @Override
    public Container getContentPane() {
        return this.page;
    }

    private void montar() {
        this.criticas = new JLabel("");
        this.criticas.setForeground(Color.RED);
        JLabel numContaLabel = this.createLabel("numConta");
        JLabel transacaoLabel = this.createLabel("transacao");
        JLabel motivoLabel = this.createLabel("motivo");
        JLabel valorLabel = this.createLabel("valor");
        JLabel dataLabel = this.createLabel("data");
        JLabel comentarioLabel = this.createLabel("comentario");
        JLabel categoriaLabel = this.createLabel("categoria");
        JLabel valorCheque24Label = this.createLabel("valorCheque24");
        JLabel valorCheque48Label = this.createLabel("valorCheque48");
        JLabel numDocumentoLabel = this.createLabel("numDocumento");
        JLabel reversalFlagLabel = this.createLabel("reversalFlag");
        JLabel reversalNumberLabel = this.createLabel("reversalNumber");
        this.setUpFormats();
        try {
            this.data = new JFormattedTextField(new MaskFormatter("##/##/####"));
            this.data.setColumns(20);
            this.valor = new JFormattedTextField(this.amountFormat);
            this.valor.setColumns(20);
            this.valorCheque24 = new JFormattedTextField(this.amountFormat);
            this.valorCheque24.setColumns(20);
            this.valorCheque48 = new JFormattedTextField(this.amountFormat);
            this.valorCheque48.setColumns(20);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Bindings.bind(this.numConta, (ValueModel)this.mPresentationModel.getBufferedModel("numConta"));
        Bindings.bind(this.transacao, (ValueModel)this.mPresentationModel.getBufferedModel("transacao"));
        Bindings.bind(this.motivo, (ValueModel)this.mPresentationModel.getBufferedModel("motivo"));
        Bindings.bind(this.valor, (ValueModel)this.mPresentationModel.getBufferedModel("valor"));
        Bindings.bind(this.data, (ValueModel)this.mPresentationModel.getBufferedModel("data"));
        Bindings.bind(this.comentario, (ValueModel)this.mPresentationModel.getBufferedModel("comentario"));
        Bindings.bind(this.categoria, (ValueModel)this.mPresentationModel.getBufferedModel("categoria"));
        Bindings.bind(this.valorCheque24, (ValueModel)this.mPresentationModel.getBufferedModel("valorCheque24"));
        Bindings.bind(this.numDocumento, (ValueModel)this.mPresentationModel.getBufferedModel("numDocumento"));
        Bindings.bind(this.valorCheque48, (ValueModel)this.mPresentationModel.getBufferedModel("valorCheque48"));
        Bindings.bind(this.reversalFlag, (ValueModel)this.mPresentationModel.getBufferedModel("reversalFlag"));
        Bindings.bind(this.reversalNumber, (ValueModel)this.mPresentationModel.getBufferedModel("reversalNumber"));
        JButton btProcessar = this.createBtProcessar();
        JButton btCancelar = this.createBtCancelar();
        JPanel painelBotao = new JPanel(new GridLayout(1, 3));
        painelBotao.setPreferredSize(new Dimension(600, 600));
        painelBotao.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 50));
        painelBotao.add(btProcessar);
        painelBotao.add(btCancelar);
        JPanel panel = new JPanel();
        FormLayout formLayout = new FormLayout("right:pref:grow, left:pref:grow", "35px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, 25px, bottom:35px");
        panel.setLayout(formLayout);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)this.criticas, cc.xywh(1, 1, 2, 1));
        panel.add((Component)numContaLabel, cc.xy(1, 2));
        panel.add((Component)this.numConta, cc.xy(2, 2));
        panel.add((Component)transacaoLabel, cc.xy(1, 3));
        panel.add((Component)this.transacao, cc.xy(2, 3));
        panel.add((Component)motivoLabel, cc.xy(1, 4));
        panel.add((Component)this.motivo, cc.xy(2, 4));
        panel.add((Component)valorLabel, cc.xy(1, 5));
        panel.add((Component)this.valor, cc.xy(2, 5));
        panel.add((Component)dataLabel, cc.xy(1, 6));
        panel.add((Component)this.data, cc.xy(2, 6));
        panel.add((Component)comentarioLabel, cc.xy(1, 7));
        panel.add((Component)this.comentario, cc.xy(2, 7));
        panel.add((Component)categoriaLabel, cc.xy(1, 8));
        panel.add((Component)this.categoria, cc.xy(2, 8));
        panel.add((Component)valorCheque24Label, cc.xy(1, 9));
        panel.add((Component)this.valorCheque24, cc.xy(2, 9));
        panel.add((Component)valorCheque48Label, cc.xy(1, 10));
        panel.add((Component)this.valorCheque48, cc.xy(2, 10));
        panel.add((Component)numDocumentoLabel, cc.xy(1, 11));
        panel.add((Component)this.numDocumento, cc.xy(2, 11));
        panel.add((Component)reversalFlagLabel, cc.xy(1, 12));
        panel.add((Component)this.reversalFlag, cc.xy(2, 12));
        panel.add((Component)reversalNumberLabel, cc.xy(1, 13));
        panel.add((Component)this.reversalNumber, cc.xy(2, 13));
        panel.add((Component)painelBotao, cc.xywh(1, 15, 2, 1, "center, bottom"));
        PainelImagem painelTopo = new PainelImagem(CBUtil.createImage("images/barra.png"));
        JLabel logo = new JLabel(CBUtil.getMensagem("messages.cyberbank.title.page.lancamento"));
        logo.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 20));
        logo.setFont(new Font("Arial", 0, 18));
        logo.setForeground(Color.WHITE);
        painelTopo.add(logo);
        this.page.add((Component)painelTopo, "North");
        this.page.add((Component)panel, "Center");
    }

    private void setUpFormats() {
        this.amountFormat = NumberFormat.getNumberInstance();
        this.amountFormat.setMaximumFractionDigits(5);
        this.amountFormat.setMinimumFractionDigits(0);
        this.amountFormat.setMaximumIntegerDigits(20);
        this.amountFormat.setMinimumIntegerDigits(1);
        this.amountFormat.setGroupingUsed(false);
        this.percentFormat = NumberFormat.getNumberInstance();
        this.percentFormat.setMinimumFractionDigits(3);
        this.paymentFormat = NumberFormat.getCurrencyInstance();
    }

    private JButton createBotao(String text) {
        JButton botao = new JButton(text);
        botao.setToolTipText(text);
        botao.setBorder(new EmptyBorder(6, 5, 6, 5));
        botao.add(Box.createRigidArea(new Dimension(100, 20)));
        return botao;
    }

    private JButton createBtProcessar() {
        JButton botao = this.createBotao(CBUtil.getMensagem("messages.cyberbank.button.process"));
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Lancamento2Page.this.mPresentationModel.triggerCommit();
                LancamentoValidator validator = (LancamentoValidator)Lancamento2Page.this.mPresentationModel.getBean();
                ValidationResult result = validator.validate();
                Lancamento2Page.this.validationResultModel.setResult(result);
                if (result.isEmpty()) {
                    LancamentoController controller = new LancamentoController((Lancamento)validator.getILancamento());
                    try {
                        SubmitService.processar(controller);
                        ResultadoPage page = new ResultadoPage((Lancamento)validator.getILancamento());
                        Janela.getInstance().show(page);
                    }
                    catch (CyberBankException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    int qtderrors = result.getMessages().size();
                    JDialog d = new JDialog();
                    d.setSize(500, qtderrors * 30 + 60);
                    d.setLocationRelativeTo(Lancamento2Page.this.page);
                    JLabel critica = new JLabel("<html>" + result.getMessagesText() + "</html>");
                    critica.setForeground(Color.RED);
                    d.add(critica);
                    d.setVisible(true);
                }
            }
        });
        return botao;
    }

    private JButton createBtCancelar() {
        JButton botao = this.createBotao(CBUtil.getMensagem("messages.cyberbank.button.cancel"));
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrincipalPage principal = new PrincipalPage();
                Janela.getInstance().show(principal);
            }
        });
        return botao;
    }
}

