/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancooriginal.cyberbank.awt.component;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MultilineTableCell
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        CellArea area = new CellArea(value.toString(), table, row, column, isSelected);
        return area;
    }

    class CellArea
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private String text;
        protected int rowIndex;
        protected int columnIndex;
        protected JTable table;
        protected Font font;
        private int paragraphStart;
        private int paragraphEnd;
        private LineBreakMeasurer lineMeasurer;

        public CellArea(String s, JTable tab, int row, int column, boolean isSelected) {
            this.text = s;
            this.rowIndex = row;
            this.columnIndex = column;
            this.table = tab;
            this.font = this.table.getFont();
            if (isSelected) {
                this.setForeground(this.table.getSelectionForeground());
                this.setBackground(this.table.getSelectionBackground());
            }
        }

        @Override
        public void paintComponent(Graphics gr) {
            super.paintComponent(gr);
            if (this.text != null && !this.text.isEmpty()) {
                Graphics2D g = (Graphics2D)gr;
                if (this.lineMeasurer == null) {
                    AttributedCharacterIterator paragraph = new AttributedString(this.text).getIterator();
                    this.paragraphStart = paragraph.getBeginIndex();
                    this.paragraphEnd = paragraph.getEndIndex();
                    FontRenderContext frc = g.getFontRenderContext();
                    this.lineMeasurer = new LineBreakMeasurer(paragraph, BreakIterator.getWordInstance(), frc);
                }
                float breakWidth = this.table.getColumnModel().getColumn(this.columnIndex).getWidth();
                float drawPosY = 0.0f;
                this.lineMeasurer.setPosition(this.paragraphStart);
                while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
                    TextLayout layout = this.lineMeasurer.nextLayout(breakWidth);
                    float drawPosX = layout.isLeftToRight() ? 0.0f : breakWidth - layout.getAdvance();
                    layout.draw(g, drawPosX, drawPosY += layout.getAscent());
                    drawPosY += layout.getDescent() + layout.getLeading();
                }
                this.table.setRowHeight(this.rowIndex, (int)drawPosY);
            }
        }
    }
}

